/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.editor;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.af3.operatorpanel.ui.editor.OP3DDisplayEditor;
import org.fortiss.af3.operatorpanel.ui.handler.InfoUtils;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP3DDisplay;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CameraDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.LightDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ObjectDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TransformDisplayNodeBase;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.graphicsGL.model.mesh.MaterialGroup3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

final class OP3DDisplayEditorUIProvider
extends DynamicTreeTableUIProviderBase<Object> {
    private final OP3DDisplayEditor editor;

    public OP3DDisplayEditorUIProvider(OP3DDisplayEditor editor) {
        this.editor = editor;
    }

    public String getLabel(Object element, int column) {
        if (column == 0) {
            if (element instanceof EObject) {
                return this.getModelElementHandlerName((EObject)element);
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "";
        }
        if (column == 1) {
            if (element instanceof OP3DDisplay) {
                return InfoUtils.getInfo((OP3DDisplay)element);
            }
            if (element instanceof Object3D) {
                return InfoUtils.getInfo((Object3D)element);
            }
            if (element instanceof ObjectDisplayNode) {
                return InfoUtils.getInfo((ObjectDisplayNode)element);
            }
            if (element instanceof TransformDisplayNodeBase) {
                return InfoUtils.getInfo((TransformDisplayNodeBase)element);
            }
            if (element instanceof CameraDisplayNode) {
                return InfoUtils.getInfo((CameraDisplayNode)element);
            }
            if (element instanceof LightDisplayNode) {
                return InfoUtils.getInfo((LightDisplayNode)element);
            }
            if (element instanceof MaterialGroup3D) {
                return InfoUtils.getInfo((MaterialGroup3D)element);
            }
            return "";
        }
        if (column == 2 && (element instanceof INamedCommentedElement || element instanceof MaterialGroup3D)) {
            return this.getModelElementHandlerDescription((EObject)element);
        }
        return "";
    }

    public Node getIconNode(Object element, int column) {
        if (column == 0 && element instanceof EObject) {
            return this.getModelElementHandlerIcon((EObject)element);
        }
        return null;
    }

    public void select(Object oldValue, Object newValue) {
        StructuredSelection selection = newValue == null ? StructuredSelection.EMPTY : new StructuredSelection(newValue);
        this.editor.getSite().getSelectionProvider().setSelection((ISelection)selection);
    }

    private String getModelElementHandlerName(EObject eo) {
        return IModelElementHandlerService.getInstance().getName(eo);
    }

    private String getModelElementHandlerDescription(EObject eo) {
        return IModelElementHandlerService.getInstance().getDescription(eo);
    }

    private Node getModelElementHandlerIcon(EObject eo) {
        if (eo == null) {
            return null;
        }
        return IModelElementHandlerService.getInstance().getFXIcon(eo);
    }

    public ContextMenu createContextMenu(Object element, int column) {
        if (element == null || !(element instanceof EObject) || column != 0) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Collection)ContextMenuUtils.createPrototypeMenu((EObject)((EObject)element), null));
        return contextMenu;
    }
}

