/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.handler;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP3DDisplay;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CameraDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.DisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.LightDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ObjectDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.RotationDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ScalingDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TransformDisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TranslationDisplayNode;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.Vector3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Material3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MaterialGroup3D;
import org.fortiss.tooling.graphicsGL.model.mesh.Mesh3D;
import org.fortiss.tooling.graphicsGL.model.scene.Camera3D;
import org.fortiss.tooling.graphicsGL.model.scene.Light3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class InfoUtils {
    public static String getInfo(MaterialGroup3D element) {
        Material3D mat = element.getMaterial();
        OP3DDisplay display = (OP3DDisplay)KernelModelElementUtils.getParentElement((EObject)element, OP3DDisplay.class, (boolean)true);
        if (display != null && !display.isUseLighting()) {
            return "color: " + InfoUtils.getVectorString(mat.getAmbient());
        }
        return "a:" + InfoUtils.getVectorString(mat.getAmbient()) + ", d:" + InfoUtils.getVectorString(mat.getDiffuse()) + ", s:" + InfoUtils.getVectorString(mat.getSpecular()) + ", shiny:" + mat.getSpecularCoeff() + ", smooth:" + element.isSmoothShading();
    }

    public static String getInfo(LightDisplayNode element) {
        Light3D light = element.getLight();
        OP3DDisplay display = (OP3DDisplay)KernelModelElementUtils.getParentElement((EObject)element, OP3DDisplay.class, (boolean)true);
        if (display != null && !display.isUseLighting()) {
            return "Lighting is OFF.";
        }
        String pos = InfoUtils.getVectorString(light.getPosition());
        if (light.isDirectional()) {
            return "from direction: " + pos;
        }
        return InfoUtils.getPrefix((DisplayNodeBase)element) + "position: " + pos;
    }

    public static String getInfo(CameraDisplayNode element) {
        Camera3D cam = element.getCamera();
        String prefix = InfoUtils.getPrefix((DisplayNodeBase)element);
        return prefix + "position: " + InfoUtils.getVectorString(cam.getPosition()) + "; " + prefix + "target: " + InfoUtils.getVectorString(cam.getLookAtLocation());
    }

    public static String getInfo(OP3DDisplay element) {
        if (element.isUseLighting()) {
            Color3D a = element.getAmbientLight();
            return "Ambient Light is R: " + a.getRed() + " G: " + a.getGreen() + " B: " + a.getBlue();
        }
        return "Lighting is OFF. Ambient component of object material will be used as color.";
    }

    public static String getInfo(ObjectDisplayNode element) {
        return "references " + element.getModel();
    }

    public static String getInfo(Object3D element) {
        if (element.getMesh() == null) {
            return "Missing mesh! Use property view to load one.";
        }
        Mesh3D m = element.getMesh();
        return InfoUtils.getFacesCount(m) + " faces";
    }

    private static int getFacesCount(Mesh3D m) {
        int count = 0;
        for (MaterialGroup3D g : m.getMaterialGroups()) {
            count += g.getFaces().size();
        }
        return count;
    }

    public static String getPrefix(DisplayNodeBase element) {
        if (element.eContainer() instanceof TransformDisplayNodeBase) {
            return "relative ";
        }
        return "absolute ";
    }

    public static String getVectorString(Vector3D t) {
        return "(" + t.getX() + ", " + t.getY() + ", " + t.getZ() + ")";
    }

    public static String getVectorString(Color3D t) {
        return "(" + t.getRed() + ", " + t.getGreen() + ", " + t.getBlue() + ")";
    }

    public static String getVectorString(TransformDisplayNodeBase t) {
        return "(" + String.valueOf(t.getX()) + ", " + String.valueOf(t.getY()) + ", " + String.valueOf(t.getZ()) + ")";
    }

    public static String getInfo(TransformDisplayNodeBase element) {
        if (element instanceof TranslationDisplayNode || element instanceof ScalingDisplayNode) {
            return InfoUtils.getVectorString(element);
        }
        if (element instanceof RotationDisplayNode) {
            RotationDisplayNode rot = (RotationDisplayNode)element;
            return "'" + String.valueOf(rot.getAngle()) + "' degree with axis " + InfoUtils.getVectorString((TransformDisplayNodeBase)rot);
        }
        return "";
    }
}

