/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.properties;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.component.ui.behavior.GuardToStringConverter;
import org.fortiss.af3.component.ui.behavior.StringToGuardConverter;
import org.fortiss.af3.component.ui.behavior.StringToGuardValidator;
import org.fortiss.af3.component.ui.utils.ComponentFieldAssistUtils;
import org.fortiss.af3.operatorpanel.model.AF3OperatorPanelPackage;
import org.fortiss.af3.operatorpanel.model.OPColorDisplay;
import org.fortiss.af3.operatorpanel.model.OPColorReaction;
import org.fortiss.af3.operatorpanel.ui.properties.ListPropertySectionBase;
import org.fortiss.af3.operatorpanel.utils.OperatorPanelModelElementFactory;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.ProposalProviderBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ColorReactionsPropertySection
extends ListPropertySectionBase<OPColorReaction> {
    private ResourceManager resourceManager;

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    @Override
    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
        super.dispose();
    }

    private static RGB getAsRGB(OPColorReaction reaction) {
        return new RGB(reaction.getRed(), reaction.getGreen(), reaction.getBlue());
    }

    @Override
    protected void addViewerColumns(EObject currentObj) {
        this.createComplexTableColumn("Guards", 350, 16384, (EStructuralFeature)AF3OperatorPanelPackage.Literals.OP_REACTION__GUARD, (IConverter)new GuardToStringConverter(), (IConverter)new StringToGuardConverter(currentObj), (IValidator)new StringToGuardValidator(currentObj), (IProposalProvider)new ProposalProviderBase(){

            public String[] getProposals(String currentWord) {
                return ComponentFieldAssistUtils.createComponentInProposals((EObject)ColorReactionsPropertySection.this.currentObject);
            }
        });
        this.createTableColumn("Color", 80, 16384, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Color getBackground(Object element) {
                return ColorReactionsPropertySection.this.resourceManager.createColor(ColorReactionsPropertySection.getAsRGB((OPColorReaction)element));
            }
        }, new EditingSupport((ColumnViewer)this.viewer){

            protected boolean canEdit(Object element) {
                return true;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ColorCellEditor((Composite)ColorReactionsPropertySection.this.viewer.getTable());
            }

            protected Object getValue(Object element) {
                return ColorReactionsPropertySection.getAsRGB((OPColorReaction)element);
            }

            protected void setValue(Object element, Object value) {
                final OPColorReaction reaction = (OPColorReaction)element;
                final RGB color = (RGB)value;
                KernelModelElementUtils.runAsCommand((EObject)reaction, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        reaction.setRed(color.red);
                        reaction.setGreen(color.green);
                        reaction.setBlue(color.blue);
                    }
                });
            }
        });
    }

    @Override
    protected OPColorReaction createListItem() {
        return OperatorPanelModelElementFactory.createOPColorReaction((int)255, (int)0, (int)0);
    }

    @Override
    protected EList<OPColorReaction> getList(EObject eo) {
        return ((OPColorDisplay)eo).getReactions();
    }
}

