/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.properties;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssist;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.kernel.ui.databinding.AbstractDecoratedTextCellDatabindingEditingSupport;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class ListPropertySectionBase<T extends EObject>
extends AbstractPropertySection {
    protected TableViewer viewer;
    protected DataBindingContext dbc = new DataBindingContext();
    protected EObject currentObject;
    private EList<T> elements;
    private final Adapter refreshListener = new EContentAdapter(){

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (ListPropertySectionBase.this.viewer != null && !ListPropertySectionBase.this.viewer.getTable().isDisposed()) {
                ListPropertySectionBase.this.viewer.refresh();
            }
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(composite, 67584);
        GridDataFactory.swtDefaults().span(1, 5).grab(true, true).align(4, 4).applyTo((Control)this.viewer.getTable());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createButtons(composite);
    }

    public void dispose() {
        if (this.currentObject != null) {
            this.currentObject.eAdapters().remove((Object)this.refreshListener);
        }
        this.dbc.dispose();
        super.dispose();
    }

    private void createButtons(Composite composite) {
        this.createButton("Add", composite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KernelModelElementUtils.runAsCommand((EObject)ListPropertySectionBase.this.currentObject, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).ListPropertySectionBase.this.elements.add(ListPropertySectionBase.this.createListItem());
                    }
                });
            }
        });
        this.createButton("Delete", composite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final int index = ListPropertySectionBase.this.viewer.getTable().getSelectionIndex();
                if (index >= 0) {
                    KernelModelElementUtils.runAsCommand((EObject)ListPropertySectionBase.this.currentObject, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ListPropertySectionBase.this.elements.remove(index);
                        }
                    });
                }
            }
        });
        this.createButton("Up", composite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final int index = ListPropertySectionBase.this.viewer.getTable().getSelectionIndex();
                if (index > 0) {
                    KernelModelElementUtils.runAsCommand((EObject)ListPropertySectionBase.this.currentObject, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ListPropertySectionBase.this.elements.move(index - 1, index);
                        }
                    });
                }
            }
        });
        this.createButton("Down", composite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final int index = ListPropertySectionBase.this.viewer.getTable().getSelectionIndex();
                if (index >= 0 && index < ListPropertySectionBase.this.elements.size() - 1) {
                    KernelModelElementUtils.runAsCommand((EObject)ListPropertySectionBase.this.currentObject, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).ListPropertySectionBase.this.elements.move(index + 1, index);
                        }
                    });
                }
            }
        });
    }

    private void createButton(String label, Composite composite, SelectionListener selectionListener) {
        Button button = new Button(composite, 8);
        button.setText(label);
        GridDataFactory.defaultsFor((Control)button).applyTo((Control)button);
        button.addSelectionListener(selectionListener);
    }

    public final void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object object = ((IStructuredSelection)selection).getFirstElement();
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        }
        Assert.isTrue((boolean)(object instanceof EObject));
        if (this.currentObject != null) {
            this.currentObject.eAdapters().remove((Object)this.refreshListener);
        }
        this.currentObject = (EObject)object;
        this.currentObject.eAdapters().add((Object)this.refreshListener);
        this.elements = this.getList(this.currentObject);
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
        this.addViewerColumns(this.currentObject);
    }

    protected abstract EList<T> getList(EObject var1);

    protected abstract T createListItem();

    protected abstract void addViewerColumns(EObject var1);

    protected TableViewerColumn createTableColumn(String label, int width, int style, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TableViewerColumn column = new TableViewerColumn(this.viewer, style);
        column.getColumn().setText(label);
        column.getColumn().setWidth(width);
        column.setLabelProvider(labelProvider);
        if (editingSupport != null) {
            column.setEditingSupport(editingSupport);
        }
        return column;
    }

    protected TableViewerColumn createComplexTableColumn(String label, int width, int style, final EStructuralFeature structuralFeature, final IConverter toTextConverter, final IConverter fromTextConverter, final IValidator textValidator, final IProposalProvider proposalProvider) {
        ColumnLabelProvider labelProvider = new ColumnLabelProvider(){

            public String getText(Object element) {
                return toTextConverter.convert(((EObject)element).eGet(structuralFeature)).toString();
            }
        };
        TableViewerColumn column = this.createTableColumn(label, width, style, (CellLabelProvider)labelProvider, null);
        AbstractDecoratedTextCellDatabindingEditingSupport editingSupport = new AbstractDecoratedTextCellDatabindingEditingSupport((ColumnViewer)this.viewer, this.dbc){

            protected IObservableValue<?> getModelObservableValue(Object model) {
                return ObservableUtils.observeValue((EObject)((EObject)model), (EStructuralFeature)structuralFeature);
            }

            protected IConverter getModelToTextConverter() {
                return toTextConverter;
            }

            protected IConverter getTextToModelConverter() {
                return fromTextConverter;
            }

            protected IValidator getTextValidator(Object element) {
                return textValidator;
            }

            protected CellEditor createCellEditor(ColumnViewer viewer) {
                CellEditor cellEditor = super.createCellEditor(viewer);
                new FieldAssist((Text)cellEditor.getControl(), proposalProvider);
                return cellEditor;
            }
        };
        column.setEditingSupport((EditingSupport)editingSupport);
        return column;
    }

    public final void refresh() {
        this.viewer.setInput(this.elements);
    }
}

