/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.properties;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.expression.ui.databinding.validate.FloatToStringConverter;
import org.fortiss.af3.expression.ui.databinding.validate.StringToFloatConverter;
import org.fortiss.af3.operatorpanel.ui.properties.DataBindingUtil;
import org.fortiss.af3.operatorpanel.ui.properties.XYZInputCompositeGUI;
import org.fortiss.tooling.graphicsGL.model.mesh.Material3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MaterialGroup3D;
import org.fortiss.tooling.graphicsGL.model.mesh.MeshPackage;
import org.fortiss.tooling.kernel.ui.databinding.FloatValidator;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

public class MaterialGroup3DPropertySection
extends PropertySectionBase {
    private MaterialGroup3D materialGroup;
    private Material3D material;
    private XYZInputCompositeGUI ambient;
    private XYZInputCompositeGUI diffuse;
    private XYZInputCompositeGUI specular;
    private Text intensity;
    private Button smoothButton;

    protected void setSectionInput(Object input) {
        this.materialGroup = (MaterialGroup3D)input;
        this.material = this.materialGroup.getMaterial();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.smoothButton = this.getWidgetFactory().createButton(this.composite, "", 32);
        this.createFormEntry((Control)this.smoothButton, "Smooth Shader:");
        this.ambient = new XYZInputCompositeGUI(this.composite, 0);
        this.switchToColor(this.ambient);
        this.createFormEntry((Control)this.ambient, "Ambient Component");
        this.diffuse = new XYZInputCompositeGUI(this.composite, 0);
        this.switchToColor(this.diffuse);
        this.createFormEntry((Control)this.diffuse, "Diffuse Component");
        this.specular = new XYZInputCompositeGUI(this.composite, 0);
        this.switchToColor(this.specular);
        this.createFormEntry((Control)this.specular, "Specular Component");
        this.intensity = this.createDecoratedFormText("Specular Shininess");
    }

    private void switchToColor(XYZInputCompositeGUI comp) {
        comp.getXLabel().setText("Red: ");
        comp.getYLabel().setText("Green: ");
        comp.getZLabel().setText("Blue: ");
    }

    public void refresh() {
        super.refresh();
        IObservableValue modelObservable = ObservableUtils.observeValue((EObject)this.materialGroup, (EStructuralFeature)MeshPackage.Literals.MATERIAL_GROUP3_D__SMOOTH_SHADING);
        this.dbc.bindValue((IObservableValue)DataBindingUtils.observeSelection((Widget)this.smoothButton), modelObservable);
        modelObservable = ObservableUtils.observeValue((EObject)this.material, (EStructuralFeature)MeshPackage.Literals.MATERIAL3_D__SPECULAR_COEFF);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)this.intensity, (IObservableValue)modelObservable, (IConverter)FloatToStringConverter.FLOAT_STRING_CONVERTER, (IConverter)StringToFloatConverter.STRING_FLOAT_CONVERTER, (IValidator)FloatValidator.FLOAT_VALIDATOR, null);
        DataBindingUtil.bindColor(this.material.getAmbient(), this.ambient, (DataBindingContext)this.dbc);
        DataBindingUtil.bindColor(this.material.getDiffuse(), this.diffuse, (DataBindingContext)this.dbc);
        DataBindingUtil.bindColor(this.material.getSpecular(), this.specular, (DataBindingContext)this.dbc);
    }
}

