/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.properties;

import java.io.File;
import java.util.List;
import org.conqat.ide.commons.ui.dialog.MessageUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP3DDisplay;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.graphicsGL.util.OBJLoaderUtil;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;

public class Object3DPropertySection
extends PropertySectionBase
implements SelectionListener {
    private Object3D node;
    private Button loadMesh;

    protected void setSectionInput(Object input) {
        this.node = (Object3D)input;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.loadMesh = this.getWidgetFactory().createButton(this.composite, "Select OBJ file ...", 8);
        this.loadMesh.addSelectionListener((SelectionListener)this);
        this.createFormEntry((Control)this.loadMesh, "Load Mesh");
    }

    public void widgetSelected(SelectionEvent e) {
        String filename = this.openFileDialog(this.composite.getShell());
        if (filename == null) {
            return;
        }
        try {
            File f = new File(filename);
            final List list = new OBJLoaderUtil(f).getLoadedObjects();
            if (list.size() == 1) {
                ICommandStackService.getInstance().runAsCommand((EObject)this.node, new Runnable(){

                    @Override
                    public void run() {
                        Object3D obj = (Object3D)list.get(0);
                        Object3DPropertySection.this.node.setName(obj.getName());
                        Object3DPropertySection.this.node.setMesh(obj.getMesh());
                    }
                });
            } else {
                ICommandStackService.getInstance().runAsCommand((EObject)this.node, new Runnable(){

                    @Override
                    public void run() {
                        OP3DDisplay display = (OP3DDisplay)Object3DPropertySection.this.node.eContainer();
                        for (Object3D o3d : list) {
                            display.getLoadedObjects().add((Object)o3d);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            MessageUtils.showError((String)"Unable to load mesh from OBJ file!", (String)ex.getMessage());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private String openFileDialog(Shell shell) {
        FileDialog fileChooser = new FileDialog(shell, 4096);
        fileChooser.setText("Open OBJ mesh file");
        fileChooser.setFilterExtensions(new String[]{"*.obj"});
        fileChooser.setFilterNames(new String[]{"Wavefront file (obj)"});
        return fileChooser.open();
    }
}

