/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.prototypes;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.operatorpanel.ui.AF3OperatorpanelUIActivator;
import org.fortiss.af3.operatorpanel.viewpanel.utils.NodeModelElementFactory;
import org.fortiss.af3.operatorpanel.viewpanel.utils.ViewPanelModelElementFactory;
import org.fortiss.tooling.graphicsGL.ToolingGraphicsGLActivator;
import org.fortiss.tooling.graphicsGL.model.scene.Camera3D;
import org.fortiss.tooling.graphicsGL.model.scene.Light3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.graphicsGL.util.OBJLoaderUtil;
import org.fortiss.tooling.kernel.extension.base.PrototypeProviderBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.ResourceUtils;

public final class PrototypeProviderViewpanel
extends PrototypeProviderBase {
    private static final String OP_CATEGORY = "Operator Panel";
    private static final String OBJ_CATEGORY = "3D Viewer Objects";
    private static final String SCENE_CATEGORY = "3D Viewer Scene";
    public static final Object3D CUBE = PrototypeProviderViewpanel.getObject("/data/default/cube");
    public static final Object3D SPHERE = PrototypeProviderViewpanel.getObject("/data/default/sphere");

    protected void registerPrototypes() {
        boolean expandedByDefault = true;
        this.registerPrototypeCategory(OP_CATEGORY, expandedByDefault);
        this.registerPrimaryPrototype("3D Viewer", (EObject)ViewPanelModelElementFactory.createDefaultOP3DDisplay((String)"3D Viewer", (String)""), OP_CATEGORY);
        this.registerPrimaryPrototype("Graph Viewer", (EObject)ViewPanelModelElementFactory.createOP2DDisplay((String)"Graph Viewer", (String)""), OP_CATEGORY);
        this.registerPrototype("Cube", (EObject)CUBE, OBJ_CATEGORY);
        this.registerPrototype("Sphere", (EObject)SPHERE, OBJ_CATEGORY);
        this.registerNodePrototypes();
    }

    private void registerNodePrototypes() {
        this.registerPrototype("Object Node", (EObject)NodeModelElementFactory.objectDisplayNode((String)"Object", (String)""), SCENE_CATEGORY);
        this.registerPrototype("Camera Node", (EObject)NodeModelElementFactory.cameraDisplayNode((String)"Camera", (String)"", (Camera3D)((Camera3D)EcoreUtils.copy((EObject)ViewPanelModelElementFactory.DEFAULT_CAMERA))), SCENE_CATEGORY);
        this.registerPrototype("Light Node", (EObject)NodeModelElementFactory.lightDisplayNode((String)"Light", (String)"", (Light3D)((Light3D)EcoreUtils.copy((EObject)ViewPanelModelElementFactory.DEFAULT_LIGHT))), SCENE_CATEGORY);
        this.registerPrototype("Translation Node", (EObject)NodeModelElementFactory.translation((String)"Translation", (String)"", (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)1.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)1.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)1.0)), SCENE_CATEGORY);
        this.registerPrototype("Rotation Node", (EObject)NodeModelElementFactory.rotation((String)"Rotation", (String)"", (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)90.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)0.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)0.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)0.0)), SCENE_CATEGORY);
        this.registerPrototype("Scaling Node", (EObject)NodeModelElementFactory.scaling((String)"Scaling", (String)"", (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)2.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)2.0), (IExpressionTerm)ExpressionModelElementFactory.doubleConst((double)2.0)), SCENE_CATEGORY);
    }

    private static Object3D getObject(String modelPath) {
        List loadedObjects;
        block3: {
            try {
                List objData = ResourceUtils.getStringContentFromResource((String)ToolingGraphicsGLActivator.PLUGIN_ID, (String)(modelPath + ".obj"));
                List mtlData = ResourceUtils.getStringContentFromResource((String)ToolingGraphicsGLActivator.PLUGIN_ID, (String)(modelPath + ".mtl"));
                loadedObjects = new OBJLoaderUtil(objData, mtlData).getLoadedObjects();
                if (!loadedObjects.isEmpty()) break block3;
                return null;
            }
            catch (Exception ex) {
                LoggingUtils.error((Plugin)AF3OperatorpanelUIActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
                return null;
            }
        }
        return (Object3D)loadedObjects.get(0);
    }
}

