/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.simulator.views;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPropertyListener;
import org.fortiss.af3.component.ui.simulator.SimulationManager;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.language.evaluation.DoubleValue;
import org.fortiss.af3.expression.language.evaluation.IntValue;
import org.fortiss.af3.operatorpanel.simulator.ExecutableOperatorPanelSpecification;
import org.fortiss.af3.operatorpanel.ui.AF3OperatorpanelUIActivator;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPViewControlBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP2DGraphDisplay;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.ui.draw.LwjglCanvas;
import org.fortiss.tooling.graphicsGL.ui.draw.LwjglRenderThread;
import org.fortiss.tooling.graphicsGL.ui.util.GLPrimitives;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.lwjgl.opengl.GL11;
import org.lwjglx.util.vector.Vector2f;
import org.newdawn.slick.Color;

public class OPVC2DGraphDisplay
extends OPViewControlBase<OP2DGraphDisplay, LwjglCanvas>
implements Listener,
IPropertyListener {
    private static final int INDENT = 8;
    private LwjglRenderThread renderThread;
    private LwjglCanvas canvas;
    private List<Term<? extends ITerm>> data = new ArrayList<Term<? extends ITerm>>();
    private List<Vector2f> graphPoints = new ArrayList<Vector2f>();
    private int minimumDisplayedSample = 0;
    private static final Font AWT_FONT = new Font("Arial", 0, 14);

    public OPVC2DGraphDisplay(OP2DGraphDisplay item, Composite parent) {
        super(item, parent);
        SimulationManager.INSTANCE.addListener((IPropertyListener)this);
    }

    @Override
    public synchronized void updateDisplay(ExecutableOperatorPanelSpecification simulation) {
        Term value = simulation.getTermValue((ITerm)((OP2DGraphDisplay)this.modelItem).getInput());
        this.data.add((Term<? extends ITerm>)value);
        this.graphPoints.clear();
        int ds = this.data.size();
        int sc = ((OP2DGraphDisplay)this.modelItem).getSamplesPerGrid() * ((OP2DGraphDisplay)this.modelItem).getHorizontalGrids();
        this.minimumDisplayedSample = sc <= ds ? ds - sc : 0;
        int i = 0;
        while (i < ds && i < sc) {
            float val = this.getFloatDataFor(this.data.get(this.minimumDisplayedSample + i));
            this.graphPoints.add(new Vector2f((float)i, val));
            ++i;
        }
    }

    private float getFloatDataFor(Term<? extends ITerm> val) {
        if (val instanceof IntValue) {
            return ((IntValue)val).toJavaValue().floatValue();
        }
        if (val instanceof DoubleValue) {
            return ((DoubleValue)val).toJavaValue().floatValue();
        }
        if (val instanceof BoolValue) {
            boolean b = ((BoolValue)val).toJavaValue();
            return b ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    protected LwjglCanvas createControl(Composite parent) {
        this.canvas = new LwjglCanvas(parent);
        this.canvas.addResizeHandler((Listener)this);
        this.renderThread = new LwjglRenderThread(this.canvas, new Runnable(){

            @Override
            public void run() {
                try {
                    OPVC2DGraphDisplay.this.performRendering();
                }
                catch (Exception ex) {
                    LoggingUtils.error((Plugin)AF3OperatorpanelUIActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        this.renderThread.start();
        return this.canvas;
    }

    public final void handleEvent(Event event) {
        Rectangle b = ((LwjglCanvas)this.control).getBounds();
        ((LwjglCanvas)this.control).setViewPortFor2D(b.width, b.height);
    }

    private synchronized void performRendering() {
        Rectangle b = ((LwjglCanvas)this.control).getBounds();
        ((LwjglCanvas)this.control).setViewPortFor2D(b.width, b.height);
        GLPrimitives.clearCanvasAndLoadIdentity((Color)Color.white);
        GLPrimitives.translate((float)48.0f, (float)8.0f, (float)0.0f);
        this.drawCoordinates(b.width - 64, b.height - 24);
        this.drawData(b.width - 64, b.height - 24);
    }

    private void drawData(int graphWidth, int graphHeight) {
        GLPrimitives.translate((float)1.0f, (float)(graphHeight / 2), (float)0.0f);
        GLPrimitives.scale((float)((float)graphWidth / (1.0f + (float)(((OP2DGraphDisplay)this.modelItem).getSamplesPerGrid() * ((OP2DGraphDisplay)this.modelItem).getHorizontalGrids()))), (float)((float)(-graphHeight) / ((float)(2 * ((OP2DGraphDisplay)this.modelItem).getVerticalGrids()) * ((OP2DGraphDisplay)this.modelItem).getLevelsPerGrid())), (float)0.0f);
        GLPrimitives.setColor((Color3D)((OP2DGraphDisplay)this.modelItem).getLineColor());
        GL11.glBegin((int)3);
        for (Vector2f v : this.graphPoints) {
            GL11.glVertex2f((float)v.x, (float)v.y);
        }
        GL11.glEnd();
    }

    private void drawCoordinates(int graphWidth, int graphHeight) {
        int w;
        String msg;
        float s = (float)graphWidth / (float)((OP2DGraphDisplay)this.modelItem).getHorizontalGrids();
        int i = 0;
        while (i <= ((OP2DGraphDisplay)this.modelItem).getHorizontalGrids()) {
            float x = (float)i * s;
            GLPrimitives.setColor((Color)Color.white);
            GLPrimitives.drawLine((float)x, (float)0.0f, (float)0.0f, (float)x, (float)graphHeight, (float)0.0f);
            if (i % 2 == 0) {
                msg = "" + (this.minimumDisplayedSample + i * ((OP2DGraphDisplay)this.modelItem).getSamplesPerGrid());
                w = this.canvas.getStringWidth(msg, AWT_FONT);
                this.canvas.drawString(msg, (int)x - w / 2, graphHeight + 2, AWT_FONT, Color.gray);
            }
            ++i;
        }
        s = (float)graphHeight / (2.0f * (float)((OP2DGraphDisplay)this.modelItem).getVerticalGrids());
        i = 0;
        while (i <= 2 * ((OP2DGraphDisplay)this.modelItem).getVerticalGrids()) {
            float y = (float)i * s;
            GLPrimitives.setColor((Color)Color.white);
            GLPrimitives.drawLine((float)0.0f, (float)y, (float)0.0f, (float)graphWidth, (float)y, (float)0.0f);
            if (i % 2 == 0) {
                msg = "" + ((OP2DGraphDisplay)this.modelItem).getLevelsPerGrid() * (float)(((OP2DGraphDisplay)this.modelItem).getVerticalGrids() - i);
                w = 3 + this.canvas.getStringWidth(msg, AWT_FONT);
                this.canvas.drawString(msg, -w, (int)y - 7, AWT_FONT, Color.gray);
            }
            ++i;
        }
        GLPrimitives.setColor((Color)Color.gray);
        GLPrimitives.drawLine((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)graphHeight, (float)0.0f);
        GLPrimitives.drawLine((float)0.0f, (float)((float)graphHeight / 2.0f), (float)0.0f, (float)graphWidth, (float)((float)graphHeight / 2.0f), (float)0.0f);
    }

    @Override
    public void dispose() {
        SimulationManager.INSTANCE.removeListener((IPropertyListener)this);
        super.dispose();
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 4) {
            this.data.clear();
            this.graphPoints.clear();
        }
    }
}

