/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.simulator.views;

import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.fortiss.af3.expression.language.evaluation.DoubleValue;
import org.fortiss.af3.operatorpanel.simulator.ExecutableOperatorPanelSpecification;
import org.fortiss.af3.operatorpanel.ui.AF3OperatorpanelUIActivator;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPViewControlBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.OP3DDisplay;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CameraDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.CompositeDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.DisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.LightDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ObjectDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.RotationDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.ScalingDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TransformDisplayNodeBase;
import org.fortiss.af3.operatorpanel.viewpanel.model.node3D.TranslationDisplayNode;
import org.fortiss.af3.operatorpanel.viewpanel.utils.DisplayNodeUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.graphicsGL.model.Color3D;
import org.fortiss.tooling.graphicsGL.model.Vector3D;
import org.fortiss.tooling.graphicsGL.model.scene.Camera3D;
import org.fortiss.tooling.graphicsGL.model.scene.Light3D;
import org.fortiss.tooling.graphicsGL.model.scene.Object3D;
import org.fortiss.tooling.graphicsGL.ui.camera.Camera;
import org.fortiss.tooling.graphicsGL.ui.draw.LwjglCanvas;
import org.fortiss.tooling.graphicsGL.ui.draw.LwjglRenderThread;
import org.fortiss.tooling.graphicsGL.ui.light.Light;
import org.fortiss.tooling.graphicsGL.ui.util.GLPrimitives;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.lwjglx.util.vector.Vector3f;
import org.lwjglx.util.vector.Vector4f;
import org.newdawn.slick.Color;

public class OPVC3DDisplay
extends OPViewControlBase<OP3DDisplay, LwjglCanvas>
implements Listener,
KeyListener {
    private LwjglRenderThread renderThread;
    private LwjglCanvas canvas;
    private Map<CameraDisplayNode, Camera> cameras = new HashMap<CameraDisplayNode, Camera>();
    private Camera[] cameraList = null;
    private int currentCamera = 0;
    private int cameraCylceTime = 0;
    private long cycleTimer = -1L;
    private String message = null;
    private Map<LightDisplayNode, Light> lights = new HashMap<LightDisplayNode, Light>();
    private boolean cameraOrLightChanged = true;
    private Map<TransformDisplayNodeBase, Object> transforms = new HashMap<TransformDisplayNodeBase, Object>();
    private Map<ObjectDisplayNode, Object3D> objects = new HashMap<ObjectDisplayNode, Object3D>();
    private static final Font AWT_FONT = new Font("Arial", 0, 14);

    public OPVC3DDisplay(OP3DDisplay item, Composite parent) {
        super(item, parent);
        this.buildMaps((DisplayNodeBase)((OP3DDisplay)this.modelItem).getScene());
        if (this.cameras.size() == 0) {
            this.cameraList = new Camera[]{new Camera()};
            this.cameraList[0].setPosition(1.0f, 1.0f, 1.0f);
        } else {
            this.cameraList = this.cameras.values().toArray(new Camera[this.cameras.size()]);
        }
        this.message = this.getCurrentCameraDisplayString();
    }

    private String getCurrentCameraDisplayString() {
        if (this.cameraList.length > 1) {
            return this.cameraList[this.currentCamera].getName() + " (Hit TAB to cycle)" + (String)(this.cameraCylceTime > 0 ? ", timer = " + this.cameraCylceTime / 1000 + "s" : "");
        }
        return null;
    }

    private void buildMaps(DisplayNodeBase dNode) {
        if (dNode instanceof CompositeDisplayNode) {
            for (DisplayNodeBase sub : ((CompositeDisplayNode)dNode).getSubNodes()) {
                this.buildMaps(sub);
            }
            if (dNode instanceof TranslationDisplayNode || dNode instanceof ScalingDisplayNode) {
                this.transforms.put((TransformDisplayNodeBase)dNode, new Vector3f(1.0f, 1.0f, 1.0f));
            } else if (dNode instanceof RotationDisplayNode) {
                this.transforms.put((TransformDisplayNodeBase)dNode, new Vector4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
        } else if (((OP3DDisplay)this.modelItem).isUseLighting() && dNode instanceof LightDisplayNode) {
            if (this.lights.size() < 8) {
                LightDisplayNode ldn = (LightDisplayNode)dNode;
                Light3D model = ldn.getLight();
                Light lght = new Light(GLPrimitives.GL_LIGHT_NUMBER[this.lights.size()], model.getAmbient(), model.getDiffuse(), model.getSpecular(), model.getAttenuation());
                Vector3D pos = ldn.getLight().getPosition();
                lght.setPosition(pos.getX(), pos.getY(), pos.getZ());
                lght.setDirectional(model.isDirectional());
                this.lights.put(ldn, lght);
            }
        } else if (dNode instanceof CameraDisplayNode) {
            CameraDisplayNode cdn = (CameraDisplayNode)dNode;
            Camera cam = new Camera(cdn.getName());
            Vector3D pos = cdn.getCamera().getPosition();
            cam.setPosition(pos.getX(), pos.getY(), pos.getZ());
            this.cameras.put(cdn, cam);
        } else if (dNode instanceof ObjectDisplayNode) {
            ObjectDisplayNode odn = (ObjectDisplayNode)dNode;
            Object3D o = DisplayNodeUtils.find3DObjectByName((OP3DDisplay)((OP3DDisplay)this.modelItem), (String)odn.getModel());
            this.objects.put(odn, o);
        }
    }

    @Override
    public synchronized void updateDisplay(ExecutableOperatorPanelSpecification simulation) {
        for (TransformDisplayNodeBase tdn : this.transforms.keySet()) {
            if (tdn instanceof TranslationDisplayNode || tdn instanceof ScalingDisplayNode) {
                this.updateTranslationOrScaling(simulation, tdn, (Vector3f)this.transforms.get(tdn));
                continue;
            }
            if (!(tdn instanceof RotationDisplayNode)) continue;
            this.updateRotation(simulation, (RotationDisplayNode)tdn, (Vector4f)this.transforms.get(tdn));
        }
        this.setCameraOrLightChanged();
    }

    private void updateTranslationOrScaling(ExecutableOperatorPanelSpecification simulation, TransformDisplayNodeBase t, Vector3f v) {
        Term val = simulation.getTermValue((ITerm)t.getX());
        if (val instanceof DoubleValue) {
            v.setX(((DoubleValue)val).toJavaValue().floatValue());
        }
        if ((val = simulation.getTermValue((ITerm)t.getY())) instanceof DoubleValue) {
            v.setY(((DoubleValue)val).toJavaValue().floatValue());
        }
        if ((val = simulation.getTermValue((ITerm)t.getZ())) instanceof DoubleValue) {
            v.setZ(((DoubleValue)val).toJavaValue().floatValue());
        }
    }

    private void updateRotation(ExecutableOperatorPanelSpecification simulation, RotationDisplayNode t, Vector4f v) {
        Term val = simulation.getTermValue((ITerm)t.getX());
        if (val instanceof DoubleValue) {
            v.setX(((DoubleValue)val).toJavaValue().floatValue());
        }
        if ((val = simulation.getTermValue((ITerm)t.getY())) instanceof DoubleValue) {
            v.setY(((DoubleValue)val).toJavaValue().floatValue());
        }
        if ((val = simulation.getTermValue((ITerm)t.getZ())) instanceof DoubleValue) {
            v.setZ(((DoubleValue)val).toJavaValue().floatValue());
        }
        if ((val = simulation.getTermValue((ITerm)t.getAngle())) instanceof DoubleValue) {
            v.setW(((DoubleValue)val).toJavaValue().floatValue());
        }
    }

    @Override
    protected LwjglCanvas createControl(Composite parent) {
        this.canvas = new LwjglCanvas(parent);
        this.canvas.addResizeHandler((Listener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.renderThread = new LwjglRenderThread(this.canvas, new Runnable(){

            @Override
            public void run() {
                try {
                    OPVC3DDisplay.this.performRendering();
                }
                catch (Exception ex) {
                    LoggingUtils.error((Plugin)AF3OperatorpanelUIActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
                }
            }
        });
        this.renderThread.start();
        return this.canvas;
    }

    public final void handleEvent(Event event) {
        this.prepareGL3D();
    }

    private void prepareGL3D() {
        Rectangle b = ((LwjglCanvas)this.control).getBounds();
        Vector3f p = this.getPerspective();
        ((LwjglCanvas)this.control).setViewportAndPerspective(b.width, b.height, p.x, p.y, p.z);
    }

    private void prepareGL2D() {
        Rectangle b = ((LwjglCanvas)this.control).getBounds();
        ((LwjglCanvas)this.control).setViewPortFor2D(b.width, b.height);
    }

    private Vector3f getPerspective() {
        return new Vector3f(45.0f, 0.5f, 400.0f);
    }

    private synchronized void performRendering() {
        this.prepareGL3D();
        this.doCameraCycling();
        if (this.cameraOrLightChanged) {
            GLPrimitives.loadIdentity();
            this.performCameraAndLightPositionPass((DisplayNodeBase)((OP3DDisplay)this.modelItem).getScene());
            this.cameraOrLightChanged = false;
        }
        GLPrimitives.clearCanvasAndLoadIdentity((Color)Color.black);
        GLPrimitives.enableBackCulling();
        GLPrimitives.enableNormalization();
        this.cameraList[this.currentCamera].applyForRendering();
        if (((OP3DDisplay)this.modelItem).isUseLighting()) {
            GLPrimitives.enableLighting((Color3D)((OP3DDisplay)this.modelItem).getAmbientLight());
            for (LightDisplayNode ldn : this.lights.keySet()) {
                this.lights.get(ldn).enableLight();
            }
        }
        this.performObjectRenderingPass((DisplayNodeBase)((OP3DDisplay)this.modelItem).getScene());
        if (this.message != null && !this.message.trim().equals("")) {
            this.prepareGL2D();
            this.canvas.drawString(this.message, 1, 1, AWT_FONT, Color.white);
        }
    }

    private void doCameraCycling() {
        long now = System.currentTimeMillis();
        if (this.cycleTimer > 0L && now - this.cycleTimer >= (long)this.cameraCylceTime) {
            this.currentCamera = (this.cameraList.length + this.currentCamera - 1) % this.cameraList.length;
            if (this.cameraCylceTime > 0) {
                this.cycleTimer = now;
            }
        }
    }

    private void performObjectRenderingPass(DisplayNodeBase dNode) {
        Object3D o;
        if (dNode instanceof CompositeDisplayNode) {
            if (dNode instanceof TransformDisplayNodeBase) {
                this.applyTransform((TransformDisplayNodeBase)dNode);
            }
            for (DisplayNodeBase sub : ((CompositeDisplayNode)dNode).getSubNodes()) {
                this.performObjectRenderingPass(sub);
            }
            if (dNode instanceof TransformDisplayNodeBase) {
                GLPrimitives.restoreMatrix();
            }
        }
        if (dNode instanceof ObjectDisplayNode && (o = this.objects.get(dNode)) != null && o.getMesh() != null) {
            GLPrimitives.drawMaterialGroups((List)o.getMesh().getMaterialGroups(), (boolean)((OP3DDisplay)this.modelItem).isUseLighting());
        }
    }

    private void performCameraAndLightPositionPass(DisplayNodeBase dNode) {
        if (dNode instanceof CompositeDisplayNode) {
            if (dNode instanceof TransformDisplayNodeBase) {
                this.applyTransform((TransformDisplayNodeBase)dNode);
            }
            for (DisplayNodeBase sub : ((CompositeDisplayNode)dNode).getSubNodes()) {
                this.performCameraAndLightPositionPass(sub);
            }
            if (dNode instanceof TransformDisplayNodeBase) {
                GLPrimitives.restoreMatrix();
            }
        } else if (((OP3DDisplay)this.modelItem).isUseLighting() && dNode instanceof LightDisplayNode) {
            Vector3D pos = ((LightDisplayNode)dNode).getLight().getPosition();
            Light lght = this.lights.get(dNode);
            Vector3f v = GLPrimitives.getTransformedVector((Vector3D)pos);
            lght.setPosition(v.x, v.y, v.z);
        } else if (dNode instanceof CameraDisplayNode) {
            Camera3D camModel = ((CameraDisplayNode)dNode).getCamera();
            Vector3D pos = camModel.getPosition();
            Camera cam = this.cameras.get(dNode);
            Vector3f vpos = GLPrimitives.getTransformedVector((Vector3D)pos);
            cam.setPosition(vpos.x, vpos.y, vpos.z);
            Vector3D trg = camModel.getLookAtLocation();
            Vector3f vtrg = GLPrimitives.getTransformedVector((Vector3D)trg);
            cam.setTarget(vtrg.getX(), vtrg.getY(), vtrg.getZ());
        }
    }

    private void applyTransform(TransformDisplayNodeBase tdn) {
        GLPrimitives.saveMatrix();
        if (tdn instanceof TranslationDisplayNode) {
            GLPrimitives.translate((Vector3f)((Vector3f)this.transforms.get(tdn)));
        } else if (tdn instanceof ScalingDisplayNode) {
            GLPrimitives.scale((Vector3f)((Vector3f)this.transforms.get(tdn)));
        } else if (tdn instanceof RotationDisplayNode) {
            GLPrimitives.rotate((Vector4f)((Vector4f)this.transforms.get(tdn)));
        }
    }

    private synchronized void setCameraOrLightChanged() {
        this.cameraOrLightChanged = true;
    }

    public void keyPressed(KeyEvent e) {
    }

    public synchronized void keyReleased(KeyEvent e) {
        if (e.character == '\t' && this.cameraList.length > 1) {
            this.currentCamera = (e.stateMask & 0x20000) != 0 ? (this.cameraList.length + this.currentCamera - 1) % this.cameraList.length : (this.currentCamera + 1) % this.cameraList.length;
            this.cameraCylceTime = 0;
            this.cycleTimer = -1L;
        } else if (e.character == 'c') {
            if (this.cameraCylceTime < 10000) {
                this.cameraCylceTime += 1000;
                this.cycleTimer = System.currentTimeMillis();
            }
        } else if (e.character == 'C' && this.cameraCylceTime > 1000) {
            this.cameraCylceTime -= 1000;
            this.cycleTimer = System.currentTimeMillis();
        }
        this.message = this.getCurrentCameraDisplayString();
    }
}

