/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.simulator.views;

import org.conqat.lib.commons.collections.Pair;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.af3.expression.model.types.TBool;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.operatorpanel.model.InputOperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.OPAreaInput;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCInputControlBase;

public class OPVCAreaInput
extends OPVCInputControlBase<OPAreaInput, Canvas> {
    private static final String[][] TYPE_TEXTS = new String[][]{{"false", "NoVal", "true"}, {"-100", "0", "100"}, {"0.0", "0.5", "1.0"}};
    private JoystickCanvas joystickCanvas;

    protected OPVCAreaInput(OPAreaInput item, Composite parent) {
        super(item, parent);
    }

    @Override
    protected Canvas createControl(Composite parent) {
        this.joystickCanvas = new JoystickCanvas(parent, 0);
        return this.joystickCanvas;
    }

    private void setSimulationValue(double dx, double dy) {
        if (this.lastSimulation != null) {
            this.lastSimulation.setCurrentValue((InputOperatorPanelItem)this.modelItem, (Object)new Pair((Object)dx, (Object)dy));
        }
    }

    @Override
    protected void updateDisplayInternal(Object currentValue) {
        if (currentValue instanceof Pair) {
            Pair pair = (Pair)currentValue;
            this.joystickCanvas.setXY((Double)pair.getFirst(), (Double)pair.getSecond());
        } else {
            this.joystickCanvas.setXY(0.5, 0.5);
        }
    }

    private final class JoystickCanvas
    extends Canvas
    implements PaintListener,
    MouseMoveListener,
    MouseListener {
        private boolean mouseDownFlag;
        private Point value;

        public JoystickCanvas(Composite parent, int style) {
            super(parent, style);
            this.mouseDownFlag = false;
            this.setXY(0.5, 0.5);
            this.addPaintListener(this);
            this.addMouseMoveListener(this);
            this.addMouseListener(this);
        }

        public void setXY(double dx, double dy) {
            Point size = this.getSize();
            this.value = new Point((int)(dx * (double)size.x), (int)((1.0 - dy) * (double)size.y));
            this.redraw();
        }

        public void paintControl(PaintEvent e) {
            int w = e.width - 1;
            int w3 = w / 3;
            int h = e.height - 1;
            int h3 = h / 3;
            e.gc.setForeground(e.gc.getDevice().getSystemColor(16));
            e.gc.setBackground(e.gc.getDevice().getSystemColor(15));
            e.gc.fillRectangle(e.x, e.y, w, h);
            e.gc.drawLine(w3, 0, w3, h);
            e.gc.drawLine(w - w3, 0, w - w3, h);
            e.gc.drawLine(0, h3, w, h3);
            e.gc.drawLine(0, h - h3, w, h - h3);
            e.gc.setForeground(e.gc.getDevice().getSystemColor(2));
            e.gc.drawRectangle(e.x, e.y, w, h);
            e.gc.setBackground(e.gc.getDevice().getSystemColor(2));
            e.gc.fillOval(this.value.x - 6, this.value.y - 6, 12, 12);
            String[] texts = this.getTexts();
            e.gc.setForeground(e.gc.getDevice().getSystemColor(7));
            Point ext = e.gc.textExtent(texts[0], 1);
            e.gc.drawString(texts[0], 2, h - 1 - ext.y, true);
            ext = e.gc.textExtent(texts[1], 1);
            e.gc.drawString(texts[1], (w - ext.x) / 2, (h - ext.y) / 2, true);
            ext = e.gc.textExtent(texts[2], 1);
            e.gc.drawString(texts[2], w - 1 - ext.x, 1, true);
        }

        private String[] getTexts() {
            if (((OPAreaInput)OPVCAreaInput.this.modelItem).getType() instanceof TBool) {
                return TYPE_TEXTS[0];
            }
            if (((OPAreaInput)OPVCAreaInput.this.modelItem).getType() instanceof TInt) {
                return TYPE_TEXTS[1];
            }
            if (((OPAreaInput)OPVCAreaInput.this.modelItem).getType() instanceof TDouble) {
                return TYPE_TEXTS[2];
            }
            return new String[]{"", "", ""};
        }

        public void mouseDoubleClick(MouseEvent e) {
            Rectangle size = this.getBounds();
            double x = this.getValue(e.x, size.width);
            x = x <= 0.33 ? 0.0 : (x >= 0.66 ? 1.0 : 0.5);
            double y = this.getValue(e.y, size.height);
            y = y <= 0.33 ? 1.0 : (y >= 0.66 ? 0.0 : 0.5);
            OPVCAreaInput.this.setSimulationValue(x, y);
        }

        public void mouseDown(MouseEvent e) {
            this.mouseDownFlag = true;
        }

        public void mouseUp(MouseEvent e) {
            this.mouseDownFlag = false;
        }

        public void mouseMove(MouseEvent e) {
            if (this.mouseDownFlag) {
                Rectangle size = this.getBounds();
                OPVCAreaInput.this.setSimulationValue(this.getValue(e.x, size.width), 1.0 - this.getValue(e.y, size.height));
            }
        }

        private double getValue(int pos, int max) {
            pos = pos < 0 ? 0 : (pos > max ? max : pos);
            return (double)pos / (double)max;
        }
    }
}

