/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.simulator.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.operatorpanel.model.InputOperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.OPITermInput;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCInputControlBase;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;

public class OPVCITermInput
extends OPVCInputControlBase<OPITermInput, Text> {
    private Text text;
    private ControlDecoration decoration;
    private ITypeChecker.IFastChecker fastChecker;

    protected OPVCITermInput(OPITermInput item, Composite parent) {
        super(item, parent);
    }

    @Override
    protected Text createControl(Composite parent) {
        this.text = new Text(parent, 2052);
        this.decoration = new ControlDecoration((Control)this.text, 16512);
        this.text.setData(DataBindingUtils.DECORATION_KEY, (Object)this.decoration);
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.decoration.setImage(errorImage);
        this.decoration.hide();
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                OPVCITermInput.this.updateDecoration();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!OPVCITermInput.this.text.getText().isEmpty()) {
                    ITerm term = TypeSystemHandler.INSTANCE.getTypeSystemCompiler().compileTerm(OPVCITermInput.this.text.getText(), (EObject)OPVCITermInput.this.modelItem);
                    OPVCITermInput.this.text.setText(term.toString());
                    OPVCITermInput.this.updateDecoration();
                }
                if (OPVCITermInput.this.lastSimulation != null) {
                    OPVCITermInput.this.lastSimulation.setCurrentValue((InputOperatorPanelItem)OPVCITermInput.this.modelItem, (Object)OPVCITermInput.this.text.getText());
                }
            }
        });
        return this.text;
    }

    private void updateDecoration() {
        IStatus inputValid = this.isInputValid();
        if (!inputValid.isOK()) {
            this.decoration.show();
            this.decoration.setDescriptionText(inputValid.getMessage());
        } else {
            this.decoration.setDescriptionText(null);
            this.decoration.hide();
        }
    }

    private IStatus isInputValid() {
        if (this.text.getText().isEmpty()) {
            return Status.OK_STATUS;
        }
        ITerm term = null;
        try {
            term = TypeSystemHandler.INSTANCE.getTypeSystemCompiler().compileTerm(this.text.getText(), (EObject)this.modelItem);
        }
        catch (ParseException e) {
            return new Status(8, "org.fortiss.af3.operatorpanel.ui.simulator.views", 1, "Parse error", null);
        }
        if (this.fastChecker == null) {
            this.fastChecker = ITypeSystemService.INSTANCE.getHandler((EObject)this.modelItem).getTypeChecker().createFastChecker(((OPITermInput)this.modelItem).getType(), (EObject)this.modelItem);
        }
        return this.fastChecker.typecheck(term);
    }

    @Override
    protected void updateDisplayInternal(Object currentValue) {
    }
}

