/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.operatorpanel.ui.simulator.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.fortiss.af3.operatorpanel.model.OPAreaInput;
import org.fortiss.af3.operatorpanel.model.OPColorDisplay;
import org.fortiss.af3.operatorpanel.model.OPITermInput;
import org.fortiss.af3.operatorpanel.model.OPLabel;
import org.fortiss.af3.operatorpanel.model.OPPushButton;
import org.fortiss.af3.operatorpanel.model.OPTextDisplay;
import org.fortiss.af3.operatorpanel.model.OPToggleButton;
import org.fortiss.af3.operatorpanel.model.OperatorPanelItem;
import org.fortiss.af3.operatorpanel.model.OperatorPanelSpecification;
import org.fortiss.af3.operatorpanel.simulator.ExecutableOperatorPanelSpecification;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCAreaInput;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCColorDisplay;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCITermInput;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCLabel;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCPushButton;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCTextDisplay;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPVCToggleButton;
import org.fortiss.af3.operatorpanel.ui.simulator.views.OPViewControlBase;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class OperationPanelSimulationComposite
extends Composite {
    public static final String ITEM_KEY = "OPItem";
    private final Rectangle clientArea;
    private final List<OPViewControlBase<?, ?>> controls = new ArrayList();

    public OperationPanelSimulationComposite(Composite parent, OperatorPanelSpecification spec) {
        super(parent, 0);
        this.clientArea = this.determineSize(spec);
        this.setLayout(new OperatorPanelLayout());
        for (OperatorPanelItem item : spec.getItems()) {
            this.controls.add(this.createControl(item));
        }
        this.layout();
        this.setSize(this.computeSize(-1, -1));
    }

    private OPViewControlBase<?, ?> createControl(OperatorPanelItem item) {
        if (item instanceof OPLabel) {
            return new OPVCLabel((OPLabel)item, (Composite)this);
        }
        if (item instanceof OPPushButton) {
            return new OPVCPushButton((OPPushButton)item, (Composite)this);
        }
        if (item instanceof OPToggleButton) {
            return new OPVCToggleButton((OPToggleButton)item, (Composite)this);
        }
        if (item instanceof OPColorDisplay) {
            return new OPVCColorDisplay((OPColorDisplay)item, (Composite)this);
        }
        if (item instanceof OPTextDisplay) {
            return new OPVCTextDisplay((OPTextDisplay)item, (Composite)this);
        }
        if (item instanceof OPITermInput) {
            return new OPVCITermInput((OPITermInput)item, (Composite)this);
        }
        if (item instanceof OPAreaInput) {
            return new OPVCAreaInput((OPAreaInput)item, (Composite)this);
        }
        return (OPViewControlBase)TransformationUtils.createTransformedObjectWithoutExceptionFor((EObject)item, OPViewControlBase.class, (ITransformationContext)new OperatorPanelTransformationContext(this));
    }

    private Rectangle determineSize(OperatorPanelSpecification spec) {
        Rectangle compositeRect = null;
        for (OperatorPanelItem item : spec.getItems()) {
            compositeRect = this.mergeBounds(compositeRect, (ILayoutedModelElement)item);
        }
        if (compositeRect == null) {
            compositeRect = new Rectangle(0, 0, 10, 10);
        }
        compositeRect.expand(10, 10);
        return compositeRect;
    }

    private Rectangle getNodeBounds(ILayoutedModelElement layouted) {
        org.fortiss.tooling.base.model.layout.Rectangle rectElement = LayoutDataUtils.getNodeBounds((ILayoutedModelElement)layouted);
        return new Rectangle(rectElement.getX(), rectElement.getY(), rectElement.getWidth(), rectElement.getHeight());
    }

    private Rectangle mergeBounds(Rectangle compositeRect, ILayoutedModelElement item) {
        Rectangle bounds = this.getNodeBounds(item);
        compositeRect = compositeRect == null ? bounds : compositeRect.getUnion(bounds);
        return compositeRect;
    }

    void updateDisplay(ExecutableOperatorPanelSpecification simulation) {
        for (OPViewControlBase<?, ?> control : this.controls) {
            control.updateDisplay(simulation);
        }
    }

    public void dispose() {
        for (OPViewControlBase<?, ?> control : this.controls) {
            control.dispose();
        }
        super.dispose();
    }

    public class OperatorPanelLayout
    extends Layout {
        protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
            return new Point(OperationPanelSimulationComposite.this.clientArea.width, OperationPanelSimulationComposite.this.clientArea.height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                ILayoutedModelElement item = (ILayoutedModelElement)control.getData(OperationPanelSimulationComposite.ITEM_KEY);
                if (item != null) {
                    Rectangle bounds = OperationPanelSimulationComposite.this.getNodeBounds(item);
                    bounds.translate(OperationPanelSimulationComposite.this.clientArea.getTopLeft().getNegated());
                    control.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                ++n2;
            }
        }
    }

    public class OperatorPanelTransformationContext
    implements ITransformationContext {
        public OperationPanelSimulationComposite composite;

        public OperatorPanelTransformationContext(OperationPanelSimulationComposite composite) {
            this.composite = composite;
        }
    }
}

