/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.quality.ui.view.fx;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.chart.BarChart;
import javafx.scene.chart.PieChart;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import javafx.util.StringConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.common.ui.javafx.style.FillStyle;
import org.fortiss.tooling.common.ui.javafx.style.FontStyle;
import org.fortiss.tooling.common.ui.javafx.style.LineStyle;
import org.fortiss.tooling.ext.quality.data.DataRootElement;
import org.fortiss.tooling.ext.quality.data.MetricData;
import org.fortiss.tooling.ext.quality.data.MetricKey;
import org.fortiss.tooling.ext.quality.data.MetricTreeNode;
import org.fortiss.tooling.ext.quality.service.IMetricUpdateListener;
import org.fortiss.tooling.ext.quality.service.IModelQualityService;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.spiderchart.control.SpiderChartViewer;
import org.fortiss.tooling.spiderchart.model.AxisBase;
import org.fortiss.tooling.spiderchart.model.DataSeries;
import org.fortiss.tooling.spiderchart.model.DoubleAxis;
import org.fortiss.tooling.spiderchart.model.SpiderChart;
import org.fortiss.tooling.spiderchart.style.AxisStyle;
import org.fortiss.tooling.spiderchart.style.ChartStyle;
import org.fortiss.tooling.spiderchart.style.DataSeriesStyle;
import org.fortiss.tooling.spiderchart.style.LegendStyle;

public class ModelQualityFXController
extends CompositeFXControllerBase<SplitPane, Node>
implements ISelectionListener,
IMetricUpdateListener {
    private static Color[] SPIDER_CHART_OVERLAY_COLORS = new Color[]{Color.GREEN, Color.BLUE, Color.RED};
    @FXML
    private ChoiceBox<MetricKey> childMetricChoiceBox;
    @FXML
    private PieChart pieChart;
    @FXML
    private BorderPane borderPane;
    @FXML
    private ChoiceBox<MetricKey> xScatterMetricChoiceBox;
    @FXML
    private ChoiceBox<MetricKey> yScatterMetricChoiceBox;
    @FXML
    private ScatterChart<Number, Number> scatterChart;
    @FXML
    private BarChart<String, Number> barChart;
    private EObject lastSelectedElement;
    private List<Pair<MetricTreeNode, Set<MetricKey>>> lastViewedElements = new ArrayList<Pair<MetricTreeNode, Set<MetricKey>>>();

    public ModelQualityFXController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "MetricsViewFx.fxml";
    }

    public void initialize() {
        final IModelQualityService mqs = IModelQualityService.getInstance();
        Collection metricKeys = mqs.getMetricKeys();
        StringConverter<MetricKey> choiceBoxStringConverter = new StringConverter<MetricKey>(){

            public String toString(MetricKey key) {
                return key == null ? "" : key.getKeyName();
            }

            public MetricKey fromString(String keyName) {
                return mqs.getMetricKey(keyName);
            }
        };
        this.childMetricChoiceBox.getItems().addAll(metricKeys);
        this.childMetricChoiceBox.setConverter((StringConverter)choiceBoxStringConverter);
        this.xScatterMetricChoiceBox.getItems().addAll(metricKeys);
        this.xScatterMetricChoiceBox.setConverter((StringConverter)choiceBoxStringConverter);
        this.yScatterMetricChoiceBox.getItems().addAll(metricKeys);
        this.yScatterMetricChoiceBox.setConverter((StringConverter)choiceBoxStringConverter);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IProjectRootElement currentRootElement;
        this.lastSelectedElement = null;
        EObject selected = (EObject)SelectionUtils.checkAndPickFirst((ISelection)selection, EObject.class);
        if (selected == null) {
            this.updateCharts("Nothing selected.");
            return;
        }
        IProjectRootElement iProjectRootElement = currentRootElement = selected instanceof IProjectRootElement ? (IProjectRootElement)selected : (IProjectRootElement)EcoreUtils.getFirstParentWithType((EObject)selected, IProjectRootElement.class);
        if (currentRootElement == null) {
            this.updateCharts("Selection does not have a project root element.");
            return;
        }
        MetricData metricData = IModelQualityService.getInstance().getMetricData();
        DataRootElement rootDataElement = (DataRootElement)metricData.getDataRootElementMap().get(currentRootElement);
        if (rootDataElement == null) {
            this.updateCharts("No metrics available");
            return;
        }
        this.lastSelectedElement = selected;
        this.updateCharts("Selection does not have metric information.");
    }

    public void onChoiceBoxChange() {
        this.updateCharts("Invalid selection or metrics not available.");
    }

    public void onChildMetricChoiceBoxChange() {
        this.updateCharts("Invalid selection or metrics not available.");
    }

    public void onScatterMetricChoiceBoxChange() {
        this.updateCharts("Invalid selection or metrics not available.");
    }

    private void updateCharts(String message) {
        if (this.lastSelectedElement != null) {
            MetricData metricData = IModelQualityService.getInstance().getMetricData();
            MetricTreeNode node = (MetricTreeNode)metricData.getTreeNodeLookupTable().get(this.lastSelectedElement);
            if (node != null) {
                if (!node.getChildren().isEmpty()) {
                    this.updatePieChart(node);
                    this.updateScatterChart(node);
                    this.updateBarChart(node);
                    this.updateLastViewedElements(node);
                    SpiderChartViewer viewer = this.buildSpiderChart();
                    this.borderPane.setCenter((Node)viewer.getViewerPane());
                    return;
                }
                message = "Selection does not have contained elements.";
            } else {
                message = "Selection does not have metric information.";
            }
        }
        this.borderPane.setCenter((Node)new Label(message));
        this.pieChart.getData().clear();
    }

    private void updatePieChart(MetricTreeNode node) {
        MetricKey selectedMetric = (MetricKey)this.childMetricChoiceBox.getValue();
        if (selectedMetric != null) {
            this.pieChart.getData().clear();
            this.pieChart.setLegendVisible(false);
            this.pieChart.setTitle("");
            DecimalFormat format = new DecimalFormat("0.#");
            for (MetricTreeNode child : node.getChildren()) {
                Double value = child.getValueAsDouble(selectedMetric);
                if (value == null) continue;
                PieChart.Data slice = new PieChart.Data(child.getName() + ": " + format.format(value), value.doubleValue());
                this.pieChart.getData().add((Object)slice);
            }
        }
    }

    private void updateScatterChart(MetricTreeNode node) {
        MetricKey xScatterKey = (MetricKey)this.xScatterMetricChoiceBox.getValue();
        MetricKey yScatterKey = (MetricKey)this.yScatterMetricChoiceBox.getValue();
        if (xScatterKey != null && yScatterKey != null) {
            this.scatterChart.getXAxis().setLabel(xScatterKey.getKeyName());
            this.scatterChart.getYAxis().setLabel(yScatterKey.getKeyName());
            this.scatterChart.getData().clear();
            for (MetricTreeNode child : node.getChildren()) {
                Double xValue = child.getValueAsDouble(xScatterKey);
                Double yValue = child.getValueAsDouble(yScatterKey);
                if (xValue == null || yValue == null) continue;
                XYChart.Series dataSeries = new XYChart.Series();
                dataSeries.setName(child.getName());
                dataSeries.getData().add((Object)new XYChart.Data((Object)xValue, (Object)yValue));
                this.scatterChart.getData().add((Object)dataSeries);
            }
        }
    }

    private void updateBarChart(MetricTreeNode node) {
        MetricKey yScatterKey = (MetricKey)this.yScatterMetricChoiceBox.getValue();
        if (yScatterKey != null) {
            this.barChart.getYAxis().setLabel(yScatterKey.getKeyName());
            this.barChart.getData().clear();
            for (MetricTreeNode child : node.getChildren()) {
                Double yValue = child.getValueAsDouble(yScatterKey);
                if (yValue == null) continue;
                XYChart.Series dataSeries = new XYChart.Series();
                dataSeries.setName(child.getName());
                dataSeries.getData().add((Object)new XYChart.Data((Object)child.getName(), (Object)yValue));
                this.barChart.getData().add((Object)dataSeries);
            }
        }
    }

    private SpiderChartViewer buildSpiderChart() {
        Set keysIntersection = (Set)this.lastViewedElements.get(0).getValue();
        for (Pair<MetricTreeNode, Set<MetricKey>> p2 : this.lastViewedElements) {
            keysIntersection.retainAll((Collection)p2.getValue());
        }
        List dataSeriesList = this.lastViewedElements.stream().map(pair -> {
            MetricTreeNode key;
            String name = (key = (MetricTreeNode)pair.getKey()).getName();
            return new Pair((Object)key, (Object)(name == null ? new DataSeries("No name found") : new DataSeries(name)));
        }).collect(Collectors.toList());
        SpiderChart spiderChart = new SpiderChart();
        spiderChart.setLegendLabel("Legend");
        ChartStyle chartStyle = new ChartStyle(true, true, true);
        chartStyle.setUseIndividualAxisSegments(false);
        chartStyle.setTitleStyle(new FontStyle("Verdana", 14.0, Color.BLUE.brighter()));
        for (MetricKey key : keysIntersection) {
            Double maxmiumValue = this.lastViewedElements.stream().mapToDouble(p -> ((MetricTreeNode)p.getKey()).getValueAsDouble(key)).max().getAsDouble();
            if (maxmiumValue == 0.0) continue;
            DoubleAxis doubleAxis = new DoubleAxis(key.getKeyName(), Double.valueOf(0.0), maxmiumValue);
            AxisStyle aStyle3Segs = new AxisStyle(LineStyle.SOLID_BLACK_1PT, FontStyle.BLACK_VERDANA_14PT, 3, FontStyle.BLACK_VERDANA_8PT, new DecimalFormat("#.##"));
            chartStyle.setAxisStyle((AxisBase)doubleAxis, aStyle3Segs);
            spiderChart.addAxis((AxisBase)doubleAxis);
            for (Pair pair2 : dataSeriesList) {
                ((DataSeries)pair2.getValue()).setPoint((AxisBase)doubleAxis, (Object)((MetricTreeNode)pair2.getKey()).getValueAsDouble(key));
            }
        }
        int i = 0;
        for (Pair pair3 : dataSeriesList) {
            spiderChart.addData((DataSeries)pair3.getValue());
            Color color = SPIDER_CHART_OVERLAY_COLORS[i];
            LineStyle olive1pt = new LineStyle(color);
            FillStyle oliveFill = new FillStyle(color, 0.25);
            DataSeriesStyle style = new DataSeriesStyle(olive1pt, oliveFill, true, true, FontStyle.BLACK_VERDANA_10PT, 7.0, new DecimalFormat("#.#"));
            chartStyle.setDataSeriesStyle((DataSeries)pair3.getValue(), style);
            ++i;
        }
        LegendStyle legendStyle = new LegendStyle(false, 5.0, FontStyle.BLACK_VERDANA_12PT);
        chartStyle.setLegendStyle(legendStyle);
        chartStyle.setAxisSegments(4);
        chartStyle.setBackgroundFillStyle(new FillStyle(Color.LIGHTGRAY));
        chartStyle.setBackgroundLineStyle(new LineStyle(Color.DARKGRAY));
        SpiderChartViewer viewer = new SpiderChartViewer(spiderChart, chartStyle);
        return viewer;
    }

    public void metricUpdate(IProjectRootElement updatedElement) {
        Platform.runLater(() -> {
            if (this.lastSelectedElement == null) {
                return;
            }
            MetricData metricData = IModelQualityService.getInstance().getMetricData();
            DataRootElement rootDataElement = (DataRootElement)metricData.getDataRootElementMap().get(updatedElement);
            this.updateCharts("Selection does not have metric information.");
        });
    }

    private void updateLastViewedElements(MetricTreeNode node) {
        HashSet keys = new HashSet();
        keys.addAll(node.getDoubleMetrics().keySet());
        keys.addAll(node.getIntegerMetrics().keySet());
        if (this.lastViewedElements.stream().allMatch(p -> p.getKey() != node)) {
            this.lastViewedElements.add((Pair<MetricTreeNode, Set<MetricKey>>)new Pair((Object)node, keys));
        }
        if (this.lastViewedElements.size() > SPIDER_CHART_OVERLAY_COLORS.length) {
            this.lastViewedElements.remove(0);
        }
    }
}

