/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.annotation.view;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationViewController;
import org.fortiss.tooling.base.ui.annotation.view.ColumnHandle;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class AnnotationFilterContentProvider
extends DynamicTreeContentProviderBase<AnnotationEntry> {
    static final String FILTER_HINT_TEXT = "type filter text (regex)";
    static final String HIERARCHY_LEVELS_ALL = "Show all levels";
    static final String HIERARCHY_LEVELS_CURRENT = "Show current level";
    static final String HIERARCHY_LEVELS_SELECTED_SUBMODEL = "Show selected sub-model";
    private Pattern filterPattern;
    private boolean filterColumnName;
    private boolean filterRowName;
    private boolean filterNameMatchCase;
    private IModelElement currentlySelectedModelElement;
    boolean restrictToSelectedModelElementType;
    private String hierarchyLevelFilter = "Show all levels";
    private Class<? extends IAnnotatedSpecification> annotationTypeFilter;

    public AnnotationFilterContentProvider() {
        this.setFilterExpression("*");
    }

    private boolean passesNameFilter(String input) {
        if (this.filterPattern == null) {
            return true;
        }
        if (input == null) {
            return false;
        }
        return this.filterPattern.matcher(input).matches();
    }

    private boolean passesSelectedElementTypeFilter(AnnotationEntry annotationEntry) {
        boolean selectedElementIsInvalid;
        boolean bl = selectedElementIsInvalid = this.currentlySelectedModelElement == null || this.currentlySelectedModelElement instanceof IProjectRootElement;
        if (selectedElementIsInvalid || this.hierarchyLevelFilter == null) {
            return true;
        }
        IModelElement modelElement = annotationEntry.getModelElement();
        int modelElementLevel = EcoreUtils.getModelElementLevel((EObject)modelElement);
        int currentlySelectedModelElementLevel = EcoreUtils.getModelElementLevel((EObject)this.currentlySelectedModelElement);
        if (this.hierarchyLevelFilter.equals(HIERARCHY_LEVELS_CURRENT)) {
            if (modelElementLevel != currentlySelectedModelElementLevel) {
                return false;
            }
            if (this.currentlySelectedModelElement.eContainer() != modelElement.eContainer()) {
                return false;
            }
        }
        if (this.hierarchyLevelFilter.equals(HIERARCHY_LEVELS_SELECTED_SUBMODEL)) {
            if (modelElementLevel < currentlySelectedModelElementLevel) {
                return false;
            }
            int levelsUp = modelElementLevel - currentlySelectedModelElementLevel;
            EObject modelElementAncestor = EcoreUtils.getModelElementAncestor((EObject)annotationEntry.getModelElement(), (int)levelsUp);
            if (this.currentlySelectedModelElement != modelElementAncestor) {
                return false;
            }
        }
        Class<?> modelElementClass = modelElement.getClass();
        Class<?> currentlySelectedModelElementClass = this.currentlySelectedModelElement.getClass();
        return !this.restrictToSelectedModelElementType || modelElementClass.equals(currentlySelectedModelElementClass);
    }

    private boolean passesAnnotationTypeFilter(Class<? extends IAnnotatedSpecification> specType) {
        return this.annotationTypeFilter == null || specType.equals(this.annotationTypeFilter);
    }

    public boolean passesColumnFilter(ColumnHandle<?> columnHandle) {
        boolean passesNameFilter;
        boolean passesHiddenFilter = !columnHandle.getEntry().isHidden(columnHandle.getAnnotatedSpecificationType());
        boolean bl = passesNameFilter = !this.filterColumnName || this.passesNameFilter(columnHandle.getColumnName());
        return passesHiddenFilter && passesNameFilter && this.passesSelectedElementTypeFilter(columnHandle.getEntry()) && this.passesAnnotationTypeFilter(columnHandle.getAnnotatedSpecificationType());
    }

    public boolean passesRowFilter(AnnotationEntry annotationEntry) {
        boolean passesNameFilter;
        IModelElement modelElement = annotationEntry.getModelElement();
        boolean bl = passesNameFilter = !this.filterRowName || !(modelElement instanceof INamedElement) || this.passesNameFilter(((INamedElement)modelElement).getName());
        return passesNameFilter && this.passesSelectedElementTypeFilter(annotationEntry);
    }

    private void setNameFilterPattern(String filterPatternString) {
        if (filterPatternString.equals(FILTER_HINT_TEXT)) {
            this.filterPattern = null;
        } else {
            try {
                int patternFlags = (this.filterNameMatchCase ? 0 : 2) | 0x20;
                this.filterPattern = Pattern.compile(".*" + filterPatternString + ".*", patternFlags);
            }
            catch (PatternSyntaxException e) {
                this.filterPattern = null;
            }
        }
    }

    public void setFilterRowName(boolean filterRowName) {
        this.filterRowName = filterRowName;
    }

    public void setFilterColumnName(boolean filterColumnName) {
        this.filterColumnName = filterColumnName;
    }

    public void setFilterNameMatchCase(boolean filterNameMatchCase) {
        this.filterNameMatchCase = filterNameMatchCase;
        if (this.filterPattern != null) {
            this.setNameFilterPattern(this.filterPattern.pattern());
        }
    }

    public void setRestrictToSelectedModelElementType(boolean restrictToSelectedModelElementType) {
        this.restrictToSelectedModelElementType = restrictToSelectedModelElementType;
    }

    public void setHierarchyLevelFilter(String hierarchyLevelFilter) {
        this.hierarchyLevelFilter = hierarchyLevelFilter;
    }

    public void setAnnotationTypeFilter(Class<? extends IAnnotatedSpecification> annotationTypeFilter) {
        this.annotationTypeFilter = annotationTypeFilter;
    }

    public void setCurrentySelectedModelElement(IModelElement currentySelectedModelElement) {
        this.currentlySelectedModelElement = currentySelectedModelElement;
    }

    protected Collection<? extends AnnotationEntry> getChildren(AnnotationEntry parent) {
        if (parent instanceof AnnotationViewController.ArtificialRoot) {
            return ((AnnotationViewController.ArtificialRoot)parent).elements;
        }
        return Collections.emptyList();
    }

    protected boolean filter(AnnotationEntry entry, String filterValue) {
        return this.passesRowFilter(entry);
    }

    public void setFilterExpression(String filterExpression) {
        if (filterExpression == null || filterExpression.isEmpty()) {
            this.setNameFilterPattern("*");
            super.setFilterExpression("*");
        } else {
            this.setNameFilterPattern(filterExpression);
            super.setFilterExpression(filterExpression);
        }
    }
}

