/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.annotation.view;

import java.util.Collection;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationViewController;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationViewUtils;
import org.fortiss.tooling.base.ui.annotation.view.ColumnHandle;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

final class AnnotationTreeTableUIProvider
extends DynamicTreeTableUIProviderBase<AnnotationEntry> {
    private final AnnotationViewController viewController;

    AnnotationTreeTableUIProvider(AnnotationViewController annotationViewFXController) {
        this.viewController = annotationViewFXController;
    }

    public String getLabel(AnnotationEntry entry, int column) {
        IModelElement element = entry.getModelElement();
        switch (column) {
            case 0: {
                return this.viewController.getNameForAnnotationEntry(entry);
            }
            case 1: {
                if (element instanceof INamedCommentedElement) {
                    return ((INamedCommentedElement)element).getComment();
                }
                return "";
            }
        }
        Class columnSpecType = this.viewController.colIdxAnnotationMap.get(column).getAnnotatedSpecificationType();
        IAnnotationValueProvider valueProvider = entry.getAnnotationValueProvider(columnSpecType);
        EStructuralFeatureDescriptor eStructuralFeatureDescriptor = valueProvider != null ? valueProvider.getEStructuralFeatureDescriptor() : null;
        Object specificationValue = entry.getSpecificationValue(columnSpecType);
        if (specificationValue instanceof Collection) {
            Collection values = (Collection)specificationValue;
            return "[" + values.stream().map(o -> this.getLabel(o, eStructuralFeatureDescriptor)).collect(Collectors.joining(", ")) + "]";
        }
        if (specificationValue != null) {
            return this.getLabel(specificationValue, eStructuralFeatureDescriptor);
        }
        return "";
    }

    private String getLabel(Object value, EStructuralFeatureDescriptor eStructuralFeatureDescriptor) {
        EObject root = null;
        if (value instanceof IModelElement) {
            root = eStructuralFeatureDescriptor.getValueRootElement((IModelElement)value);
        }
        return AnnotationViewUtils.getValueLabel(value, root);
    }

    public Color getBackgroundColor(int column, AnnotationEntry element) {
        if (element.getModelElement().equals(this.viewController.selected)) {
            return AnnotationViewUtils.SELECTED_ANNOTATION_BACKGROUND_COLOR;
        }
        if (column > 1 && this.viewController.colIdxAnnotationMap.containsKey(column)) {
            Class specType = this.viewController.colIdxAnnotationMap.get(column).getAnnotatedSpecificationType();
            return AnnotationViewUtils.getBackgroundColorForEntry(element, specType);
        }
        return super.getBackgroundColor(column, (Object)element);
    }

    public void updateValue(AnnotationEntry element, int column, Object value) {
        IAnnotatedSpecification spec = this.getAnnotation(column, element);
        this.viewController.setAnnotationEntryValue(spec, element, value);
        super.updateValue((Object)element, column, value);
    }

    public boolean isElementEditable(int column, AnnotationEntry ae) {
        IAnnotationValueProvider valueProvider;
        IAnnotatedSpecification spec = this.getAnnotation(column, ae);
        IAnnotationValueProvider iAnnotationValueProvider = valueProvider = spec != null ? ae.getAnnotationValueProvider(spec.getClass()) : null;
        return valueProvider != null && valueProvider.canEdit(spec);
    }

    private IAnnotatedSpecification getAnnotation(int column, AnnotationEntry ae) {
        if (column > 1 && this.viewController.colIdxAnnotationMap.containsKey(column)) {
            ColumnHandle<IAnnotatedSpecification> columnHandle = this.viewController.colIdxAnnotationMap.get(column);
            Class specType = columnHandle.getAnnotatedSpecificationType();
            IAnnotationValueService as = IAnnotationValueService.getInstance();
            IAnnotatedSpecification spec = as.getAnnotationEntry(ae.getModelElement()).getSpecification(specType);
            return spec;
        }
        return null;
    }

    public boolean isEditable(int column) {
        if (column <= 1) {
            return false;
        }
        for (AnnotationEntry ae : this.viewController.root.elements) {
            if (!this.isElementEditable(column, ae)) continue;
            return true;
        }
        return false;
    }
}

