/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.annotation.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.AnnotationValueService;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationFilterContentProvider;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationTreeTableUIProvider;
import org.fortiss.tooling.base.ui.annotation.view.AnnotationViewUtils;
import org.fortiss.tooling.base.ui.annotation.view.ColumnHandle;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.util.SelectionUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.HierarchicalNameComparator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AnnotationViewController
extends CompositeFXControllerBase<SplitPane, Node>
implements ISelectionListener {
    private static final String SHOW_ALL_ANNOTATION_TYPES = "Show all annotation types";
    @FXML
    private TextField txtFilterText;
    @FXML
    private RadioButton radBtnFilterModelElements;
    @FXML
    private RadioButton radBtnFilterAnnotationNames;
    @FXML
    private CheckBox chkBoxMatchCase;
    @FXML
    private CheckBox chkBoxselectedTypeOnly;
    @FXML
    private ComboBox<String> comboHierarchy;
    @FXML
    private ComboBox<String> comboAnnotationType;
    @FXML
    private TreeTableView<AnnotationEntry> annotationTreeTableView;
    private DynamicTreeTableViewer<AnnotationEntry> annotationViewer;
    private IProjectRootElement curentRootElement;
    private Set<ColumnHandle<IAnnotatedSpecification>> columnHandles = new TreeSet<ColumnHandle<IAnnotatedSpecification>>();
    private Map<ColumnHandle<IAnnotatedSpecification>, TreeTableColumn<AnnotationEntry, ?>> columnHandleToColumn = new HashMap();
    private Map<String, IAnnotatedSpecification> colNameToSpecification = new HashMap<String, IAnnotatedSpecification>();
    private final AnnotationFilterContentProvider filterContentProvider = new AnnotationFilterContentProvider();
    Map<Integer, ColumnHandle<IAnnotatedSpecification>> colIdxAnnotationMap = new HashMap<Integer, ColumnHandle<IAnnotatedSpecification>>();
    ArtificialRoot root = new ArtificialRoot();
    IModelElement selected;

    public AnnotationViewController() {
        super(new ICompositeFXController[0]);
    }

    public String getFXMLLocation() {
        return "AnnotationView.fxml";
    }

    public void initialize() {
        this.setupFilterWidgets();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        EObject selected = (EObject)SelectionUtils.checkAndPickFirst((ISelection)selection, EObject.class);
        if (selected == null) {
            this.clearTableViewer();
            return;
        }
        this.curentRootElement = selected instanceof IProjectRootElement ? (IProjectRootElement)selected : (IProjectRootElement)EcoreUtils.getFirstParentWithType((EObject)selected, IProjectRootElement.class);
        if (this.curentRootElement == null) {
            this.clearTableViewer();
            return;
        }
        if (selected instanceof IModelElement) {
            this.filterContentProvider.setCurrentySelectedModelElement((IModelElement)selected);
            this.selected = (IModelElement)selected;
        }
        this.setupAnnotationTree();
        ObservableList annotationTypeOptions = this.comboAnnotationType.getItems();
        annotationTypeOptions.clear();
        annotationTypeOptions.add((Object)SHOW_ALL_ANNOTATION_TYPES);
        List annotations = this.columnHandles.stream().map(h -> h.getColumnName()).collect(Collectors.toList());
        annotationTypeOptions.addAll(annotations);
        this.comboAnnotationType.setValue((Object)SHOW_ALL_ANNOTATION_TYPES);
    }

    private void setupAnnotationTree() {
        if (this.curentRootElement == null) {
            return;
        }
        this.clearTableViewer();
        EList listElements = EcoreUtils.getChildrenWithType((EObject)this.curentRootElement, IModelElement.class);
        if (this.curentRootElement instanceof IModelElement) {
            listElements.add((Object)((IModelElement)this.curentRootElement));
        }
        this.root = new ArtificialRoot();
        for (IModelElement elem : listElements) {
            AnnotationEntry entry = IAnnotationValueService.getInstance().getAnnotationEntry(elem);
            if (entry == null || entry.getSpecificationsList().isEmpty()) continue;
            this.root.elements.add(entry);
        }
        Collections.sort(this.root.elements);
        HashSet annotationEntries = new HashSet();
        listElements.forEach(e -> {
            boolean bl = annotationEntries.add(AnnotationValueService.getInstance().getAnnotationEntry(e));
        });
        for (AnnotationEntry entry : annotationEntries) {
            for (IAnnotatedSpecification spec : entry.getSpecificationsList()) {
                ColumnHandle columnHandle = new ColumnHandle(entry, spec.getClass());
                this.columnHandles.add(columnHandle);
                this.colNameToSpecification.put(columnHandle.getColumnName(), spec);
            }
        }
        boolean showRoot = false;
        int revealLevel = 1;
        AnnotationTreeTableUIProvider uiProvider = new AnnotationTreeTableUIProvider(this);
        this.annotationViewer = new DynamicTreeTableViewer(this.annotationTreeTableView, (Object)this.root, showRoot, revealLevel, (DynamicTreeContentProviderBase)this.filterContentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.annotationViewer.addColumn("Model Element", 200);
        this.annotationViewer.addColumn("Comment", 250);
        int columnIdx = 2;
        for (ColumnHandle<IAnnotatedSpecification> handle : this.columnHandles) {
            TreeTableColumn<AnnotationEntry, ?> col = this.createColumnForHandle(columnIdx, handle);
            this.columnHandleToColumn.put(handle, col);
            ++columnIdx;
        }
        this.filterColumns();
    }

    private void clearTableViewer() {
        this.colIdxAnnotationMap.clear();
        this.columnHandles.clear();
        this.columnHandleToColumn.clear();
        this.annotationTreeTableView.getColumns().clear();
    }

    private void setupFilterWidgets() {
        this.comboAnnotationType.getItems().add((Object)SHOW_ALL_ANNOTATION_TYPES);
        this.comboAnnotationType.setValue((Object)SHOW_ALL_ANNOTATION_TYPES);
        ObservableList hierarchyLevels = this.comboHierarchy.getItems();
        hierarchyLevels.clear();
        hierarchyLevels.add((Object)"Show all levels");
        hierarchyLevels.add((Object)"Show current level");
        hierarchyLevels.add((Object)"Show selected sub-model");
        this.comboHierarchy.setValue((Object)"Show all levels");
        this.comboHierarchy.valueProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setHierarchyLevelFilter((String)nVal);
            this.updateAnnotationTree();
        });
        this.txtFilterText.textProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setFilterExpression((String)nVal);
            if (this.radBtnFilterAnnotationNames.isSelected()) {
                this.filterColumns();
            }
            this.updateAnnotationTree();
        });
        this.radBtnFilterAnnotationNames.selectedProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setFilterColumnName((boolean)nVal);
            this.filterColumns();
            if (nVal.booleanValue()) {
                this.radBtnFilterModelElements.setSelected(false);
            }
            this.updateAnnotationTree();
        });
        this.radBtnFilterModelElements.selectedProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setFilterRowName((boolean)nVal);
            if (nVal.booleanValue()) {
                this.radBtnFilterAnnotationNames.setSelected(false);
            }
            this.updateAnnotationTree();
        });
        this.chkBoxMatchCase.selectedProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setFilterNameMatchCase((boolean)nVal);
            if (this.radBtnFilterAnnotationNames.isSelected()) {
                this.filterColumns();
            }
            this.updateAnnotationTree();
        });
        this.chkBoxselectedTypeOnly.selectedProperty().addListener((obs, oVal, nVal) -> {
            this.filterContentProvider.setRestrictToSelectedModelElementType((boolean)nVal);
            this.updateAnnotationTree();
        });
        this.comboAnnotationType.valueProperty().addListener((obs, oVal, nVal) -> {
            IAnnotatedSpecification selectedSpec = this.colNameToSpecification.get(nVal);
            if (selectedSpec != null) {
                this.filterContentProvider.setAnnotationTypeFilter(selectedSpec.getClass());
            } else {
                this.filterContentProvider.setAnnotationTypeFilter(null);
            }
            this.filterColumns();
            this.updateAnnotationTree();
        });
    }

    private void updateAnnotationTree() {
        this.annotationViewer.update();
        this.annotationViewer.expandAllItems();
    }

    private void filterColumns() {
        for (ColumnHandle<IAnnotatedSpecification> c : this.columnHandles) {
            TreeTableColumn<AnnotationEntry, ?> col = this.columnHandleToColumn.get(c);
            col.setVisible(this.filterContentProvider.passesColumnFilter(c));
        }
        this.updateAnnotationTree();
    }

    private TreeTableColumn<AnnotationEntry, ?> createColumnForHandle(int columnIdx, ColumnHandle<IAnnotatedSpecification> handle) {
        Class annotationType = handle.getAnnotatedSpecificationType();
        AnnotationEntry entry = handle.getEntry();
        IAnnotationValueProvider valueProvider = entry.getAnnotationValueProvider(annotationType);
        IAnnotatedSpecification specification = entry.getSpecification(annotationType);
        EStructuralFeatureDescriptor featureDescriptor = valueProvider.getEStructuralFeatureDescriptor();
        EClassifier valueType = featureDescriptor.getEType(specification);
        String columnName = valueProvider.getAnnotationName(specification);
        this.colIdxAnnotationMap.put(columnIdx, handle);
        TreeTableColumn column = null;
        if (valueType == null) {
            column = this.annotationViewer.addColumn(columnName, 150);
            column.setEditable(false);
            return column;
        }
        column = valueType instanceof EEnum || valueType instanceof EClass ? this.annotationViewer.addComboColumn(columnName, 150, rowEntry -> {
            IAnnotatedSpecification entrySpec = (IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf((Class)annotationType, (List)rowEntry.getSpecificationsList());
            IModelElement entryElement = rowEntry.getModelElement();
            Map<Object, String> comboValues = this.getComboValues(featureDescriptor, entrySpec, entryElement);
            return comboValues;
        }) : (valueType.getInstanceClass().equals(Boolean.class) ? this.annotationViewer.addCheckboxColumn(columnName, 100) : this.annotationViewer.addColumn(columnName, 150));
        if (column != null) {
            column.setEditable(true);
        }
        return column;
    }

    private Map<Object, String> getComboValues(EStructuralFeatureDescriptor featureDescriptor, IAnnotatedSpecification specification, IModelElement modelElement) {
        EClassifier eType = featureDescriptor.getEType(specification);
        if (eType instanceof EEnum) {
            TreeMap<Object, String> rval = new TreeMap<Object, String>(new Comparator<Object>(){

                @Override
                public int compare(Object e1, Object e2) {
                    return Integer.compare(((Enumerator)e1).getValue(), ((Enumerator)e2).getValue());
                }
            });
            for (EEnumLiteral lit : featureDescriptor.getEnumLiterals((EEnum)eType, (EObject)modelElement)) {
                rval.put(lit.getInstance(), lit.getLiteral());
            }
            return rval;
        }
        if (eType instanceof EClass) {
            EObject root = featureDescriptor.getValueRootElement(modelElement);
            if (root == null) {
                return Collections.emptyMap();
            }
            BasicEList refValues = new BasicEList();
            if (featureDescriptor.getEReferenceScope() == EStructuralFeatureDescriptor.EReferenceScope.SUB_MODEL) {
                refValues.add((Object)root);
            }
            Class clazz = eType.getInstanceClass();
            for (EObject obj : EcoreUtils.getChildrenWithType((EObject)root, (Class)clazz)) {
                if (!featureDescriptor.isAvailableObject(obj, specification, (EObject)modelElement)) continue;
                refValues.add((Object)obj);
            }
            TreeMap<Object, String> rval = new TreeMap<Object, String>((Comparator<Object>)new HierarchicalNameComparator());
            for (EObject obj : refValues) {
                rval.put(obj, AnnotationViewUtils.getValueLabel(obj, root));
            }
            return rval;
        }
        return Collections.emptyMap();
    }

    void setAnnotationEntryValue(IAnnotatedSpecification specification, AnnotationEntry annotationEntry, Object newValue) {
        ITopLevelElement tle = IPersistencyService.getInstance().getTopLevelElementFor((EObject)this.curentRootElement);
        tle.runAsCommand(() -> {
            try {
                annotationEntry.setSpecificationValue(newValue, specification.getClass());
            }
            catch (Exception e1) {
                LoggingUtils.showWarning((String)("Problem during setting an AnnotationValue: \n" + String.valueOf(e1.getStackTrace())));
            }
        });
    }

    String getNameForAnnotationEntry(AnnotationEntry entry) {
        IModelElement modelElement = entry.getModelElement();
        if (modelElement instanceof INamedCommentedElement) {
            return ((INamedCommentedElement)modelElement).getName();
        }
        return "";
    }

    protected final class ArtificialRoot
    extends AnnotationEntry {
        List<AnnotationEntry> elements;

        public ArtificialRoot() {
            super(AnnotationViewController.this.selected);
            this.elements = new ArrayList<AnnotationEntry>();
        }
    }
}

