/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.annotation.view;

import javafx.scene.paint.Color;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class AnnotationViewUtils {
    public static final Color READ_ONLY_EMPTY_ANNOTATION_BACKGROUND_COLOR = Color.LIGHTGREY;
    @Deprecated
    public static final org.eclipse.swt.graphics.Color READ_ONLY_EMPTY_ANNOTATION_BACKGROUND_COLOR_SWT = AnnotationViewUtils.convertFXColortoSWT(READ_ONLY_EMPTY_ANNOTATION_BACKGROUND_COLOR);
    public static final Color READ_ONLY_ANNOTATION_BACKGROUND_COLOR = Color.BISQUE;
    protected static final Color SELECTED_ANNOTATION_BACKGROUND_COLOR = Color.LIGHTSEAGREEN;

    public static Color getBackgroundColorForEntry(AnnotationEntry annotationEntry, Class<? extends IAnnotatedSpecification> annotationType) {
        IAnnotationValueProvider valueProvider = annotationEntry.getAnnotationValueProvider(annotationType);
        IAnnotatedSpecification specification = annotationEntry.getSpecification(annotationType);
        if (valueProvider != null && valueProvider.getAnnotationValue(specification) != null && !valueProvider.canEdit(specification)) {
            return READ_ONLY_ANNOTATION_BACKGROUND_COLOR;
        }
        if (valueProvider == null || !valueProvider.canEdit(specification)) {
            return READ_ONLY_EMPTY_ANNOTATION_BACKGROUND_COLOR;
        }
        return Color.WHITE;
    }

    @Deprecated
    public static org.eclipse.swt.graphics.Color getSWTBackgroundColorForEntry(AnnotationEntry annotationEntry, Class<? extends IAnnotatedSpecification> annotationType, org.eclipse.swt.graphics.Color defaultColor) {
        Color bgCol = AnnotationViewUtils.getBackgroundColorForEntry(annotationEntry, annotationType);
        if (bgCol.equals((Object)Color.WHITE)) {
            return defaultColor;
        }
        return AnnotationViewUtils.convertFXColortoSWT(bgCol);
    }

    @Deprecated
    private static org.eclipse.swt.graphics.Color convertFXColortoSWT(Color color) {
        Display device = Display.getCurrent();
        int red = (int)color.getRed();
        int green = (int)color.getGreen();
        int blue = (int)color.getBlue();
        return new org.eclipse.swt.graphics.Color((Device)device, red, green, blue);
    }

    public static String getValueLabel(Object modelELement, EObject root) {
        if (modelELement instanceof INamedElement) {
            if (root instanceof INamedElement) {
                return KernelModelElementUtils.computeRelativeName((INamedElement)((INamedElement)root), (INamedElement)((INamedElement)modelELement));
            }
            return KernelModelElementUtils.computeFullyQualifiedName((INamedElement)((INamedElement)modelELement));
        }
        return modelELement.toString();
    }
}

