/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.base.ui.dialog.ButtonDialogGUI;

public class ButtonDialog
extends Dialog {
    private String title;
    private String message;
    private List<String> buttonNames;
    private ButtonDialogGUI gui;
    private int selection;

    public ButtonDialog(Shell parentShell, String dialogTitle, String dialogMessage, List<String> buttonNames) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.buttonNames = buttonNames;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.gui = new ButtonDialogGUI(composite, 0, this.buttonNames);
        this.gui.setLayoutData(new GridData(1808));
        for (final Button button : this.gui.getButtons()) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ButtonDialog.this.selection = ButtonDialog.this.gui.getButtons().indexOf(button);
                    ButtonDialog.this.okPressed();
                }
            });
        }
        ButtonDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public int getSelection() {
        return this.selection;
    }
}

