/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fortiss.tooling.base.ui.dialog.ElementTreeMultiSelectDialogGUI;
import org.fortiss.tooling.base.ui.dialog.MultiRootTreeContentProvider;

public class ElementTreeMultiSelectDialog
extends TitleAreaDialog {
    private ArrayList<Object> rootElements;
    private ArrayList<Object> selectedElements;
    private ITreeContentProvider contentSupport;
    private ILabelProvider labelSupport;
    private ElementTreeMultiSelectDialogGUI gui;

    public ElementTreeMultiSelectDialog(Shell parentShell, List<?> roots, List<?> selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        super(parentShell);
        this.rootElements = roots == null ? new ArrayList() : new ArrayList(roots);
        this.selectedElements = selected == null ? new ArrayList() : new ArrayList(selected);
        this.contentSupport = contentProvider;
        this.labelSupport = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.setTitle("Select");
        this.setMessage("Select one or more elements");
        Composite area = (Composite)super.createDialogArea(parent);
        this.gui = new ElementTreeMultiSelectDialogGUI(area, 0);
        this.gui.getSelectButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeMultiSelectDialog.this.selectElement();
            }
        });
        this.gui.getDeselectButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeMultiSelectDialog.this.deselectElement();
            }
        });
        this.gui.getElementTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeMultiSelectDialog.this.selectElement();
            }
        });
        this.gui.getSelectTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeMultiSelectDialog.this.deselectElement();
            }
        });
        this.gui.getElementTreeViewer().setLabelProvider((IBaseLabelProvider)new DecorateLabelProvider());
        this.gui.getSelectTreeViewer().setLabelProvider((IBaseLabelProvider)new DecorateLabelProvider());
        this.gui.getElementTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider(this.rootElements, this.contentSupport));
        this.gui.getSelectTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider(this.selectedElements, (ITreeContentProvider)new EmptyTreeContentProvider()));
        this.gui.getElementTreeViewer().setInput(this.rootElements);
        this.gui.getSelectTreeViewer().setInput(this.selectedElements);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    public List<Object> getRootElements() {
        return this.rootElements;
    }

    public List<Object> getSelectedElements() {
        return this.selectedElements;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentSupport;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelSupport;
    }

    private void selectElement() {
        try {
            ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (!this.selectedElements.contains(path.getLastSegment())) {
                    this.selectedElements.add(path.getLastSegment());
                    this.gui.getSelectTreeViewer().add(this.selectedElements, path.getLastSegment());
                    this.gui.getElementTreeViewer().update(path.getLastSegment(), null);
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void deselectElement() {
        try {
            ITreeSelection selection = (ITreeSelection)this.gui.getSelectTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (this.selectedElements.remove(path.getLastSegment())) {
                    this.gui.getSelectTreeViewer().remove(path.getLastSegment());
                    this.gui.getElementTreeViewer().update(path.getLastSegment(), null);
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private class DecorateLabelProvider
    extends LabelProvider {
        private DecorateLabelProvider() {
        }

        public String getText(Object element) {
            return ElementTreeMultiSelectDialog.this.labelSupport.getText(element);
        }

        public Image getImage(Object element) {
            Image image = ElementTreeMultiSelectDialog.this.labelSupport.getImage(element);
            if (!ElementTreeMultiSelectDialog.this.selectedElements.contains(element)) {
                return image;
            }
            Image icon = ResourceManager.getPluginImage((String)"org.eclipse.ui", (String)"/icons/full/ovr16/pinned_ovr.gif");
            if (icon == null) {
                return image;
            }
            return ResourceManager.decorateImage((Image)image, (Image)icon, (int)4);
        }
    }

    private static class EmptyTreeContentProvider
    extends TreeContentProviderBase {
        private EmptyTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }
    }
}

