/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.dialog;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialogGUI;
import org.fortiss.tooling.base.ui.dialog.IDialogEditSupport;
import org.fortiss.tooling.base.ui.dialog.MultiRootTreeContentProvider;

public class ElementTreeSingleSelectDialog
extends TitleAreaDialog {
    private IDialogEditSupport dialogEditSupport;
    private ArrayList<Object> rootElements;
    private TreePath selectedPath;
    private ITreeContentProvider contentSupport;
    private ILabelProvider labelSupport;
    private ElementTreeSingleSelectDialogGUI gui;
    private String dialogTitle = "Select";
    private String selectionMessage = "Select an element";

    public ElementTreeSingleSelectDialog(Shell parentShell, List<?> roots, Object selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IDialogEditSupport edit) {
        super(parentShell);
        this.rootElements = roots == null ? new ArrayList() : new ArrayList(roots);
        this.dialogEditSupport = edit;
        this.contentSupport = contentProvider;
        this.labelSupport = labelProvider;
        this.selectedPath = selected == null ? null : this.computeTreePath(this.rootElements, selected);
    }

    public ElementTreeSingleSelectDialog(Shell parentShell, String dialogTitle, String selectionMessage, List<?> roots, Object selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IDialogEditSupport edit) {
        this(parentShell, roots, selected, contentProvider, labelProvider, edit);
        this.dialogTitle = dialogTitle;
        this.selectionMessage = selectionMessage;
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.setTitle(this.dialogTitle);
        this.setMessage(this.selectionMessage);
        Composite area = (Composite)super.createDialogArea(parent);
        this.gui = new ElementTreeSingleSelectDialogGUI(area, 0);
        this.gui.setLayoutData(new GridData(1808));
        if (this.dialogEditSupport == null) {
            this.gui.getLeftToolBar().setVisible(false);
            ((GridData)this.gui.getLeftToolBar().getLayoutData()).exclude = true;
        }
        this.gui.getElementTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelSupport);
        this.gui.getElementTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider(this.rootElements, this.contentSupport));
        this.gui.getElementTreeViewer().setInput(this.rootElements);
        if (this.selectedPath != null) {
            this.gui.getElementTreeViewer().setSelection((ISelection)new TreeSelection(this.selectedPath), true);
        }
        this.gui.getCreateButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSingleSelectDialog.this.createElement();
            }
        });
        this.gui.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSingleSelectDialog.this.deleteElement();
            }
        });
        this.gui.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSingleSelectDialog.this.editElement();
            }
        });
        this.gui.getElementTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementTreeSingleSelectDialog.this.selectElement();
            }
        });
        return area;
    }

    protected Point getInitialSize() {
        return new Point(480, 480);
    }

    public IDialogEditSupport getEditSupport() {
        return this.dialogEditSupport;
    }

    public List<Object> getRootElements() {
        return this.rootElements;
    }

    public Object getSelectedElement() {
        if (this.selectedPath == null) {
            return null;
        }
        return this.selectedPath.getLastSegment();
    }

    public ElementTreeSingleSelectDialogGUI getGui() {
        return this.gui;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentSupport;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelSupport;
    }

    private void createElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            TreePath path;
            ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
            if (selection.getPaths() != null && selection.getPaths().length != 1) {
                return;
            }
            Object o = selection.getPaths() == null ? this.dialogEditSupport.createElement(null) : this.dialogEditSupport.createElement(selection.getPaths()[0].getLastSegment());
            if (o == null) {
                return;
            }
            if (selection.getPaths() == null) {
                path = new TreePath(new Object[]{this.rootElements});
                this.rootElements.add(o);
            } else {
                path = selection.getPaths()[0];
            }
            this.gui.getElementTreeViewer().add((Object)path, o);
            this.gui.getElementTreeViewer().expandToLevel((Object)path, 1);
            this.gui.getElementTreeViewer().reveal(o);
            this.gui.getElementTreeViewer().refresh();
            TreeSelection sel = new TreeSelection(path.createChildPath(o));
            this.gui.getElementTreeViewer().setSelection((ISelection)sel);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void deleteElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (this.dialogEditSupport.deleteElement(path.getLastSegment())) {
                    if (this.rootElements.contains(path.getLastSegment())) {
                        this.rootElements.remove(path.getLastSegment());
                    }
                    this.gui.getElementTreeViewer().remove((Object)path);
                    if (path.equals((Object)this.selectedPath)) {
                        this.selectedPath = null;
                    }
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void editElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
            if (selection.getPaths() == null || selection.getPaths().length != 1) {
                return;
            }
            TreePath path = selection.getPaths()[0];
            this.dialogEditSupport.editElement(path.getLastSegment());
            this.gui.getElementTreeViewer().refresh();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void selectElement() {
        ITreeSelection selection = (ITreeSelection)this.gui.getElementTreeViewer().getSelection();
        if (selection.getPaths() == null || selection.getPaths().length != 1 || !this.acceptElement(selection.getPaths()[0].getLastSegment())) {
            this.selectedPath = null;
            this.getButton(0).setEnabled(false);
        } else {
            this.selectedPath = selection.getPaths()[0];
            this.getButton(0).setEnabled(true);
        }
    }

    public boolean acceptElement(Object element) {
        return true;
    }

    private TreePath computeTreePath(List<?> roots, Object leaf) {
        LinkedList<Object> path = new LinkedList<Object>();
        Object parent = leaf;
        while (!roots.contains(parent)) {
            path.addFirst(parent);
            parent = this.contentSupport.getParent(parent);
            if (parent != null) continue;
            return null;
        }
        path.addFirst(parent);
        return new TreePath(path.toArray());
    }
}

