/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.utils.BaseMathUtils;

public class MultiFieldInputDialog
extends Dialog {
    private Composite container;
    private IAnnotationValueProvider.AnnotationActionReqInputParameters parameters;
    private IAnnotatedSpecification annotation;
    private IAnnotationValueProvider.AnnotationActionInputParameters parameterValues = new IAnnotationValueProvider.AnnotationActionInputParameters();
    private Map<Text, IAnnotationValueProvider.AnnotationActionInputParameter> fieldParamAssoc = new HashMap<Text, IAnnotationValueProvider.AnnotationActionInputParameter>();

    public MultiFieldInputDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.container = new Composite(area, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        this.container.setLayout((Layout)layout);
        this.addAllInputFields(this.parameters);
        return area;
    }

    public void loadAllInputFields(IAnnotationValueProvider.AnnotationActionReqInputParameters inputParameterList, IAnnotatedSpecification annotation) {
        this.parameters = inputParameterList;
        this.annotation = annotation;
    }

    protected void addAllInputFields(IAnnotationValueProvider.AnnotationActionReqInputParameters inputParameterList) {
        for (IAnnotationValueProvider.AnnotationActionReqInputParameter curParameter : inputParameterList) {
            EStructuralFeatureDescriptor featureDescr = (EStructuralFeatureDescriptor)curParameter.getSecond();
            if (featureDescr == null) continue;
            Class inputParamType = featureDescr.getEType(this.annotation).getInstanceClass();
            IAnnotationValueProvider.AnnotationActionInputParameter inputParam = new IAnnotationValueProvider.AnnotationActionInputParameter((String)curParameter.getFirst(), inputParamType);
            this.parameterValues.add((String)curParameter.getFirst(), inputParamType);
            this.addInputFields(inputParam);
        }
    }

    protected void addInputFields(IAnnotationValueProvider.AnnotationActionInputParameter parameter) {
        Label parameterLabel = new Label(this.container, 0);
        parameterLabel.setText((String)parameter.getFirst());
        GridData gridInputParameter = new GridData();
        gridInputParameter.grabExcessHorizontalSpace = true;
        gridInputParameter.horizontalAlignment = 4;
        Text parameterInput = new Text(this.container, 2048);
        parameterInput.setLayoutData((Object)gridInputParameter);
        this.fieldParamAssoc.put(parameterInput, parameter);
    }

    public IAnnotationValueProvider.AnnotationActionInputParameters getParameterValues() {
        return this.parameterValues;
    }

    protected void okPressed() {
        for (Map.Entry<Text, IAnnotationValueProvider.AnnotationActionInputParameter> curInputField : this.fieldParamAssoc.entrySet()) {
            String enteredValue = curInputField.getKey().getText();
            Class expectedType = (Class)curInputField.getValue().getSecond();
            Number value = BaseMathUtils.getNumberFromString((String)enteredValue, (Class)expectedType);
            this.parameterValues.put((String)curInputField.getValue().getFirst(), expectedType, value);
        }
        super.okPressed();
    }
}

