/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.dnd.jface;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.ui.dnd.CompositionServiceLocalDNDTransfer;
import org.fortiss.tooling.kernel.ui.util.DragAndDropUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ViewerElementCompositionDropAdapter
extends ViewerDropAdapter {
    Object lastTarget = null;

    public ViewerElementCompositionDropAdapter(Viewer viewer) {
        super(viewer);
        this.setExpandEnabled(true);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target == null) {
            target = this.getViewer().getInput();
        }
        this.lastTarget = target;
        if (this.lastTarget instanceof EObject) {
            EObject dropped = DragAndDropUtils.extractDroppedEObject((Object)CompositionServiceLocalDNDTransfer.getInstance().getObject());
            return IElementCompositorService.getInstance().canCompose((EObject)this.lastTarget, dropped, null);
        }
        return false;
    }

    public boolean performDrop(Object data) {
        if (this.lastTarget instanceof EObject) {
            final EObject target = (EObject)this.lastTarget;
            final EObject dropped = DragAndDropUtils.extractDroppedEObject((Object)data);
            final IElementCompositorService instance = IElementCompositorService.getInstance();
            if (instance.canCompose(target, dropped, null)) {
                KernelModelElementUtils.runAsCommand((EObject)target, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        instance.compose(target, dropped, null);
                    }
                });
                return true;
            }
        }
        return false;
    }

    public int getSupportedDNDOperations() {
        return 1;
    }

    public void dragEnter(DropTargetEvent event) {
        event.detail = 1;
        super.dragEnter(event);
    }

    public Transfer[] getPreferredTransfers() {
        return DragAndDropUtils.getCompositionServiceTransfers();
    }
}

