/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.fortiss.tooling.base.ui.dnd.jface.ViewerElementCompositionDropAdapter;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.IActionService;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.util.EObjectSelectionUtils;

public class AdvancedTreeViewerEditorBase<T extends EObject>
extends EditorBase<T>
implements ContextMenuContextProvider {
    protected TreeViewer treeViewer;
    protected MenuManager menuManager;
    protected Composite rootComposite;
    protected final Adapter editedObjectChanged = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() != 8 && !AdvancedTreeViewerEditorBase.this.treeViewer.getTree().isDisposed()) {
                AdvancedTreeViewerEditorBase.this.treeViewer.refresh(true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.rootComposite = new Composite(parent, 0);
        this.rootComposite.setLayout((Layout)new GridLayout(1, false));
        this.rootComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = this.createTreeViewer(this.rootComposite);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setAutoExpandLevel(-1);
        this.setupTreeViewer(this.treeViewer);
        ViewerElementCompositionDropAdapter dndAdapter = new ViewerElementCompositionDropAdapter((Viewer)this.treeViewer);
        this.treeViewer.addDropSupport(dndAdapter.getSupportedDNDOperations(), dndAdapter.getPreferredTransfers(), (DropTargetListener)dndAdapter);
        this.setTreeViewerInput();
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    protected void setTreeViewerInput() {
        this.treeViewer.setInput((Object)this.editedObject);
        this.editedObject.eAdapters().add((Object)this.editedObjectChanged);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent);
    }

    public void dispose() {
        this.editedObject.eAdapters().remove((Object)this.editedObjectChanged);
        super.dispose();
    }

    protected Collection<EObject> getTreeSelection() {
        List result = EObjectSelectionUtils.getEObjectElements((ISelection)this.treeViewer.getSelection());
        if (result.isEmpty()) {
            result.add(this.editedObject);
        }
        return result;
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setupTreeViewer(TreeViewer treeViewer) {
        this.menuManager = IContextMenuService.getInstance().createDefaultContextMenu((ContextMenuContextProvider)this);
        Menu contextMenu = this.menuManager.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)treeViewer);
        treeViewer.getControl().addKeyListener((KeyListener)new ViewerKeyAdapter());
        treeViewer.expandAll();
    }

    public EObject getSelectedModelElement() {
        if (this.getSite().getSelectionProvider() != null) {
            return EObjectSelectionUtils.getFirstElement((ISelection)this.getSite().getSelectionProvider().getSelection());
        }
        return null;
    }

    public List<EObject> getSelectedModelElementList() {
        if (this.getSite().getSelectionProvider() != null) {
            return EObjectSelectionUtils.getEObjectElements((ISelection)this.getSite().getSelectionProvider().getSelection());
        }
        return null;
    }

    private class ViewerKeyAdapter
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
            if ((e.stateMask & 0x40000) != 0 && e.keyCode == 99) {
                IActionService.getInstance().runGlobalCopyAction();
            } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
                IActionService.getInstance().runGlobalPasteAction();
            } else if (e.keyCode == 127) {
                IActionService.getInstance().runGlobalDeleteAction();
            } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 120) {
                IActionService.getInstance().runGlobalCutAction();
            } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 122) {
                IActionService.getInstance().runGlobalUndoAction();
            } else if ((e.stateMask & 0x40000) != 0 && e.keyCode == 121) {
                IActionService.getInstance().runGlobalRedoAction();
            }
        }
    }
}

