/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor;

import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.TextStyledTextActionHandler;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.tooling.base.ui.editor.SourceEditorUndoRedo;
import org.fortiss.tooling.base.ui.editor.annotations.AnnotationHover;
import org.fortiss.tooling.base.ui.editor.annotations.AnnotationMarkerAccess;
import org.fortiss.tooling.base.ui.editor.annotations.ErrorAnnotation;
import org.fortiss.tooling.base.ui.utils.FontUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;
import org.fortiss.tooling.kernel.ui.service.IActionService;

public abstract class SourceEditorBase<T extends EObject>
extends EditorBase<T> {
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private ScrolledForm scrldfrm;
    protected SourceViewer sourceViewer;
    protected AnnotationModel annotationModel = new AnnotationModel();
    private EditSource editSource = new EditSource();
    protected final Pattern pattern = Pattern.compile("line (\\d*):(\\d*) (.*)");

    public AnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public void createPartControl(Composite parent) {
        this.installModelChangeListener();
        parent.setLayout((Layout)new FillLayout());
        this.scrldfrm = this.formToolkit.createScrolledForm(parent);
        this.formToolkit.paintBordersFor((Composite)this.scrldfrm);
        this.scrldfrm.setText(this.getTitleText());
        this.scrldfrm.getBody().setLayout((Layout)new FillLayout(256));
        this.formToolkit.decorateFormHeading(this.scrldfrm.getForm());
        this.createCodeEditor(this.scrldfrm.getBody());
        this.updateModel();
    }

    protected abstract String getTitleText();

    protected void installModelChangeListener() {
        this.getEditedObject().eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getEventType() == 1) {
                    if (!this.isTargetFeature(notification) || !this.isUpdateableAndRequired()) {
                        return;
                    }
                    if (SourceEditorBase.this.editSource.editor) {
                        return;
                    }
                    SourceEditorBase.this.editSource.model = true;
                    String formattedCode = SourceEditorBase.this.getStringRepresentation();
                    SourceEditorBase.this.sourceViewer.getTextWidget().setText(formattedCode);
                    SourceEditorBase.this.sourceViewer.unconfigure();
                    SourceEditorBase.this.sourceViewer.configure(SourceEditorBase.this.getSourceViewerConfig());
                    SourceEditorBase.this.editSource.model = false;
                    SourceEditorBase.this.showErrors();
                }
            }

            private boolean isTargetFeature(Notification notification) {
                EAttribute feature;
                return notification.getFeature() instanceof EAttribute && (feature = (EAttribute)notification.getFeature()) == SourceEditorBase.this.getTargetFeature();
            }

            private boolean isUpdateableAndRequired() {
                if (SourceEditorBase.this.toBeParsed()) {
                    return false;
                }
                return SourceEditorBase.this.sourceViewer.getTextWidget() != null && !SourceEditorBase.this.sourceViewer.getTextWidget().getText().equals(SourceEditorBase.this.getStringRepresentation());
            }
        });
    }

    protected abstract EAttribute getTargetFeature();

    private void createCodeEditor(Composite parent) {
        AnnotationMarkerAccess fAnnotationAccess = new AnnotationMarkerAccess();
        CompositeRuler fCompositeRuler = new CompositeRuler();
        OverviewRuler fOverviewRuler = new OverviewRuler((IAnnotationAccess)fAnnotationAccess, 12, new ISharedTextColors(){

            public Color getColor(RGB rgb) {
                return SWTResourceManager.getColor((RGB)rgb);
            }

            public void dispose() {
            }
        });
        AnnotationRulerColumn annotationRuler = new AnnotationRulerColumn((IAnnotationModel)this.annotationModel, 16, (IAnnotationAccess)fAnnotationAccess);
        fCompositeRuler.setModel((IAnnotationModel)this.annotationModel);
        fOverviewRuler.setModel((IAnnotationModel)this.annotationModel);
        fCompositeRuler.addDecorator(0, (IVerticalRulerColumn)annotationRuler);
        annotationRuler.addAnnotationType((Object)ErrorAnnotation.ERROR_TYPE);
        fOverviewRuler.addAnnotationType((Object)ErrorAnnotation.ERROR_TYPE);
        fOverviewRuler.addHeaderAnnotationType((Object)ErrorAnnotation.ERROR_TYPE);
        fOverviewRuler.setAnnotationTypeLayer((Object)ErrorAnnotation.ERROR_TYPE, 3);
        fOverviewRuler.setAnnotationTypeColor((Object)ErrorAnnotation.ERROR_TYPE, SWTResourceManager.getColor((RGB)ErrorAnnotation.ERROR_RGB));
        this.sourceViewer = new SourceViewer(parent, (IVerticalRuler)fCompositeRuler, (IOverviewRuler)fOverviewRuler, true, 770);
        this.sourceViewer.setDocument((IDocument)new Document(), (IAnnotationModel)this.annotationModel);
        Menu menu = new Menu((Decorations)parent.getShell(), 8);
        StyledText editor = this.sourceViewer.getTextWidget();
        SourceEditorBase.createMenuItem(menu, "Cut", () -> editor.invokeAction(131199));
        SourceEditorBase.createMenuItem(menu, "Copy", () -> editor.invokeAction(17039369));
        SourceEditorBase.createMenuItem(menu, "Paste", () -> editor.invokeAction(16908297));
        editor.setMenu(menu);
        AnnotationBarHoverManager fAnnotationHoverManager = new AnnotationBarHoverManager((IVerticalRulerInfo)fCompositeRuler, (ISourceViewer)this.sourceViewer, (IAnnotationHover)new AnnotationHover(this.annotationModel), (IInformationControlCreator)new AnnotationConfiguration());
        fAnnotationHoverManager.install(annotationRuler.getControl());
        AnnotationPainter ap = new AnnotationPainter((ISourceViewer)this.sourceViewer, (IAnnotationAccess)fAnnotationAccess);
        ap.addAnnotationType(null, (Object)ErrorAnnotation.ERROR_TYPE);
        ap.setAnnotationTypeColor((Object)ErrorAnnotation.ERROR_TYPE, SWTResourceManager.getColor((RGB)ErrorAnnotation.ERROR_RGB));
        this.sourceViewer.addPainter((IPainter)ap);
        this.sourceViewer.configure(this.getSourceViewerConfig());
        final Font font = FontUtils.createFont(FontUtils.CODEFONT_11PT);
        this.sourceViewer.getTextWidget().setFont(font);
        new SourceEditorUndoRedo(this.sourceViewer.getTextWidget());
        this.sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (SourceEditorBase.this.editSource.model) {
                    return;
                }
                if (event.getDocumentEvent() != null) {
                    if (!this.isInitialLoading(event)) {
                        SourceEditorBase.this.editSource.editor = true;
                        ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor(SourceEditorBase.this.getEditedObject());
                        modelContext.runAsCommand(() -> SourceEditorBase.this.setStringRepresentation(SourceEditorBase.this.sourceViewer.getTextWidget().getText()));
                        SourceEditorBase.this.editSource.editor = false;
                    }
                    SourceEditorBase.this.showErrors();
                }
            }

            private boolean isInitialLoading(TextEvent event) {
                return event.getDocumentEvent().getModificationStamp() == 1L;
            }
        });
        this.sourceViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
    }

    protected abstract SourceViewerConfiguration getSourceViewerConfig();

    protected abstract String getStringRepresentation();

    protected abstract void setStringRepresentation(String var1);

    public abstract void showErrors();

    public void registerGlobalActions(IActionBars bars) {
        IActionService.getInstance().registerGlobalUndoRedoActions(bars);
        super.registerGlobalActions(bars);
    }

    protected void addTextStyledText(TextStyledTextActionHandler textStyledTextActionHandler) {
        textStyledTextActionHandler.addText(this.sourceViewer.getTextWidget());
    }

    public void dispose() {
        super.dispose();
    }

    protected abstract void updateModel();

    protected abstract boolean toBeParsed();

    protected static void createMenuItem(Menu menu, String description, final Runnable r) {
        MenuItem pasteItem = new MenuItem(menu, 8);
        pasteItem.setText(description);
        pasteItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                r.run();
            }
        });
    }

    public static class AnnotationConfiguration
    implements IInformationControlCreator {
        public IInformationControl createInformationControl(Shell shell) {
            return new DefaultInformationControl(shell);
        }
    }

    private class EditSource {
        public boolean editor = false;
        public boolean model = false;

        private EditSource() {
        }
    }
}

