/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.PatternRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fortiss.tooling.base.ui.editor.SourceEditorBase;
import org.fortiss.tooling.base.ui.editor.annotations.AnnotationHover;

public abstract class SourceEditorConfigurationBase<T extends EObject>
extends SourceViewerConfiguration {
    protected SourceEditorBase<T> editor;
    protected Color DARK_RED = SWTResourceManager.getColor((int)128, (int)0, (int)0);
    protected Color DARK_BLUE = SWTResourceManager.getColor((int)0, (int)0, (int)128);
    protected Color COMMENT_COLOR = SWTResourceManager.getColor((int)0, (int)148, (int)0);
    public static final String COMMENT_START_IDENTIFIER = "/*";
    public static final String COMMENT_END_IDENTIFIER = "*/";
    protected IWordDetector detector = new IWordDetector(){

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_';
        }
    };

    public SourceEditorConfigurationBase(SourceEditorBase<T> editor) {
        this.editor = editor;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    private ITokenScanner getScanner() {
        return this.getScannerForSyntaxHighlighting();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover(this.editor.getAnnotationModel());
    }

    private RuleBasedScanner getScannerForSyntaxHighlighting() {
        ArrayList<Object> allRules = new ArrayList<Object>();
        allRules.addAll(this.getCommonRules());
        allRules.add(this.getRuleSpecificToEditor());
        allRules.add(this.getCommentRuleSpecificToEditor());
        IRule[] rules = allRules.toArray(new IRule[0]);
        RuleBasedScanner scanner = new RuleBasedScanner();
        scanner.setRules(rules);
        return scanner;
    }

    protected abstract List<WordRule> getCommonRules();

    protected abstract WordRule getRuleSpecificToEditor();

    protected abstract PatternRule getCommentRuleSpecificToEditor();

    protected void addWordsToRule(List<String> words, WordRule rule, IToken token) {
        for (String word : words) {
            rule.addWord(word, token);
        }
    }
}

