/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.base.ui.dnd.jface.ViewerElementCompositionDropAdapter;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;
import org.fortiss.tooling.kernel.ui.util.EObjectSelectionUtils;

public abstract class TreeViewerEditorBase<T extends EObject>
extends EditorBase<T> {
    private TreeViewer treeViewer;
    boolean redraw;
    private final Adapter editedObjectChanged = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 8) {
                Display.getDefault().asyncExec(() -> {
                    if (!TreeViewerEditorBase.this.treeViewer.getTree().isDisposed() && TreeViewerEditorBase.this.getRedraw()) {
                        TreeViewerEditorBase.this.treeViewer.refresh(true);
                    }
                });
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 68354);
        this.redraw = true;
        this.setupTreeViewer(this.treeViewer);
        ViewerElementCompositionDropAdapter dndAdapter = new ViewerElementCompositionDropAdapter((Viewer)this.treeViewer);
        this.treeViewer.addDropSupport(dndAdapter.getSupportedDNDOperations(), dndAdapter.getPreferredTransfers(), (DropTargetListener)dndAdapter);
        this.treeViewer.setInput((Object)this.editedObject);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.editedObject.eAdapters().add((Object)this.editedObjectChanged);
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public void dispose() {
        this.editedObject.eAdapters().remove((Object)this.editedObjectChanged);
        super.dispose();
    }

    protected Collection<EObject> getTreeSelection() {
        List result = EObjectSelectionUtils.getEObjectElements((ISelection)this.treeViewer.getSelection());
        if (result.isEmpty()) {
            result.add(this.editedObject);
        }
        return result;
    }

    protected abstract void setupTreeViewer(TreeViewer var1);

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setRedraw(boolean redraw) {
        this.redraw = redraw;
        if (this.treeViewer.getTree().isDisposed()) {
            return;
        }
        this.treeViewer.getTree().setRedraw(redraw);
        if (redraw) {
            this.treeViewer.refresh(true);
        }
    }

    boolean getRedraw() {
        return this.redraw;
    }
}

