/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Dragboard;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.ui.editor.fx.controller.EObjectModelChangeProvider;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.base.ui.utils.FXDNDUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DefaultDiagramController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;

public class EObjectDiagramController<T extends EObject>
extends DefaultDiagramController {
    private final EObjectModelChangeProvider modelChangeProvider;

    public EObjectDiagramController(IMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
        this.modelChangeProvider = new EObjectModelChangeProvider((EObject)this.getModelElement());
    }

    public IModelChangeProvider getModelChangeProvider() {
        return this.modelChangeProvider;
    }

    protected T getModelElement() {
        return (T)((EObject)this.getModel());
    }

    public List<MenuItem> contextMenuContributions(Node node, DiagramCoordinate diagramLocation) {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        double x = Math.max(features.getHorizontalSpacing(), diagramLocation.getX());
        double y = Math.max(features.getVerticalSpacing(), diagramLocation.getY());
        T modelParent = this.getModelElement();
        IElementCompositionContext edc = ContextMenuUtils.createElementCompositionContext(modelParent, x, y, true, this.getViewer().getFeatures().getCurrentZoomFactor());
        List<MenuItem> result = ContextMenuUtils.createPrototypeMenu(modelParent, edc);
        result.addAll(IContextMenuService.getInstance().getFXMenuItemsForElement(modelParent, null));
        result.addAll(super.contextMenuContributions(node, diagramLocation));
        if (modelParent instanceof IHierarchicElement && this.enableAutoLayout()) {
            result.add(ContextMenuUtils.createAutoLayoutMenu((IHierarchicElement)modelParent));
        }
        return result;
    }

    protected boolean enableAutoLayout() {
        return true;
    }

    public boolean handleExternalDNDDragOver(Dragboard db, DiagramCoordinate diagramLocation) {
        double zoom = this.getViewer().getFeatures().getCurrentZoomFactor();
        return FXDNDUtils.canCompose(db, diagramLocation, this.getModelElement(), true, zoom);
    }

    public boolean handleExternalDNDDrop(Dragboard db, DiagramCoordinate diagramLocation) {
        double zoom = this.getViewer().getFeatures().getCurrentZoomFactor();
        return FXDNDUtils.compose(db, diagramLocation, this.getModelElement(), true, zoom);
    }
}

