/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.List;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.editor.fx.controller.NamedCommentedLayoutModelChangeProvider;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.base.ui.utils.FXDNDUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.change.Change;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.IClickController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.ClickControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.elliptic.EllipticResizableContentControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

public abstract class EObjectEllipticResizableContentControllerBase<T extends INamedCommentedElement & ILayoutedModelElement>
extends EllipticResizableContentControllerBase {
    private final NamedCommentedLayoutModelChangeProvider<T> layoutModelChangeProvider;
    private final IClickController openEditorDoubleClickController = new ClickControllerBase(){

        public Change singleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
            return EObjectEllipticResizableContentControllerBase.super.getClickController(node, diagramLocation).singleClick(event, node, diagramLocation);
        }

        public Change secondaryClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
            return EObjectEllipticResizableContentControllerBase.super.getClickController(node, diagramLocation).secondaryClick(event, node, diagramLocation);
        }

        public Change doubleClick(MouseEvent event, Node node, DiagramCoordinate diagramLocation) {
            Object eo = EObjectEllipticResizableContentControllerBase.this.getModelElement();
            IModelElementHandler handler = IModelElementHandlerService.getInstance().getModelElementHandler(eo);
            if (handler != null) {
                eo = handler.handleOpenModelElementRequest(eo);
            }
            IModelEditorBindingService.getInstance().openInEditor(eo);
            return null;
        }
    };

    public EObjectEllipticResizableContentControllerBase(IContentMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
        INamedCommentedElement lme = (INamedCommentedElement)mvcb.getModel();
        this.layoutModelChangeProvider = new NamedCommentedLayoutModelChangeProvider<T>(lme){

            @Override
            protected boolean acceptNotification(Notification notification) {
                if (notification.getNotifier() != this.getModelElement()) {
                    return false;
                }
                return EObjectEllipticResizableContentControllerBase.this.isAnchorageFeature(notification.getFeature());
            }
        };
    }

    protected T getModelElement() {
        return (T)((INamedCommentedElement)this.getModel());
    }

    public IModelChangeProvider getModelChangeProvider() {
        return this.layoutModelChangeProvider;
    }

    public List<MenuItem> contextMenuContributions(Node node, DiagramCoordinate diagramLocation) {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        double x = Math.max(features.getHorizontalSpacing(), diagramLocation.getX());
        double y = Math.max(features.getVerticalSpacing(), diagramLocation.getY());
        EObject modelParent = (EObject)this.getModel();
        IElementCompositionContext edc = ContextMenuUtils.createElementCompositionContext(modelParent, x, y, false, this.getViewer().getFeatures().getCurrentZoomFactor());
        List<MenuItem> menuItems = ContextMenuUtils.createPrototypeMenu(modelParent, edc);
        menuItems.addAll(IContextMenuService.getInstance().getFXMenuItemsForElement(modelParent, null));
        return menuItems;
    }

    public void delete() {
        IElementCompositorService.getInstance().decompose(this.getModelElement());
    }

    protected boolean isAnchorageFeature(Object feature) {
        return feature == ElementPackage.Literals.IHIERARCHIC_ELEMENT__CONNECTORS;
    }

    public IClickController getClickController(Node node, DiagramCoordinate diagramLocation) {
        return this.openEditorDoubleClickController;
    }

    public boolean handleExternalDNDDragOver(Dragboard db, DiagramCoordinate diagramLocation) {
        double zoom = this.getViewer().getFeatures().getCurrentZoomFactor();
        return FXDNDUtils.canCompose(db, diagramLocation, this.getModelElement(), false, zoom);
    }

    public boolean handleExternalDNDDrop(Dragboard db, DiagramCoordinate diagramLocation) {
        double zoom = this.getViewer().getFeatures().getCurrentZoomFactor();
        return FXDNDUtils.compose(db, diagramLocation, this.getModelElement(), false, zoom);
    }
}

