/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.ModelChangeProviderBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;

abstract class KernelServiceBasedModelChangeProviderBase<T extends EObject>
extends ModelChangeProviderBase
implements CommandStackListener {
    private static final IPersistencyService persistencyService = IPersistencyService.getInstance();
    private static final ICommandStackService commandStackService = ICommandStackService.getInstance();
    private final List<Notification> notifications = new ArrayList<Notification>();

    KernelServiceBasedModelChangeProviderBase() {
    }

    protected abstract T getModelElement();

    protected abstract Adapter getNotificationListener();

    protected final void addNotification(Notification event) {
        this.notifications.add(event);
    }

    protected final void connectToModel() {
        this.notifications.clear();
        T modelElement = this.getModelElement();
        Adapter notificationListener = this.getNotificationListener();
        ITopLevelElement root = persistencyService.getTopLevelElementFor(modelElement);
        commandStackService.addCommandStackListener(root, (CommandStackListener)this);
        modelElement.eAdapters().add((Object)notificationListener);
    }

    protected final void disconnectFromModel() {
        T modelElement = this.getModelElement();
        Adapter notificationListener = this.getNotificationListener();
        modelElement.eAdapters().remove((Object)notificationListener);
        ITopLevelElement root = persistencyService.getTopLevelElementFor(modelElement);
        commandStackService.removeCommandStackListener(root, (CommandStackListener)this);
        this.notifications.clear();
    }

    public void commandStackChanged(EventObject event) {
        if (this.notifications.isEmpty()) {
            return;
        }
        this.fireUpdateComplete();
        this.notifications.clear();
    }
}

