/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ConnectionDragContext;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.ui.editor.fx.controller.NamedCommentedLayoutModelChangeProvider;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.DelegatingContentAnchorageController;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

public class LayoutedContentAnchorageController<T extends INamedCommentedElement & ILayoutedModelElement>
extends DelegatingContentAnchorageController {
    private final NamedCommentedLayoutModelChangeProvider<T> layoutModelChangeProvider;

    public LayoutedContentAnchorageController(IContentAnchorageMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
        INamedCommentedElement lme = (INamedCommentedElement)mvcb.getModel();
        this.layoutModelChangeProvider = new NamedCommentedLayoutModelChangeProvider<INamedCommentedElement>(lme);
    }

    public ILayoutedModelElement getLayoutedME() {
        return (ILayoutedModelElement)this.getModel();
    }

    public IModelChangeProvider getModelChangeProvider() {
        return this.layoutModelChangeProvider;
    }

    public void delete() {
        IElementCompositorService.getInstance().decompose((EObject)this.getLayoutedME());
    }

    protected boolean canLink(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        IConnectionCompositorService ccs = IConnectionCompositorService.getInstance();
        EObject start = (EObject)startBundle.getModel();
        EObject end = (EObject)endBundle.getModel();
        EObject root = (EObject)this.getViewer().getRootElement();
        return ccs.canConnect(start, end, root, null);
    }

    protected void link(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        EObject start = (EObject)startBundle.getModel();
        EObject end = (EObject)endBundle.getModel();
        EObject root = (EObject)this.getViewer().getRootElement();
        Point sourcePosition = LWFXEditorUtils.convertDiagramCoordinateToPoint(startLocation);
        Point targetPosition = LWFXEditorUtils.convertDiagramCoordinateToPoint(endLocation);
        boolean isSourceFreeConnector = false;
        boolean isSourceRoot = start == root;
        boolean isTargetFreeConnector = false;
        boolean isTargetRoot = end == root;
        ConnectionDragContext context = new ConnectionDragContext(start, start.eContainer(), sourcePosition, end, end.eContainer(), targetPosition, isSourceFreeConnector, isSourceRoot, isTargetFreeConnector, isTargetRoot);
        IConnectionCompositorService.getInstance().connect(start, end, root, (IConnectionCompositionContext)context);
    }

    public boolean isPossibleLinkTarget() {
        return true;
    }

    public MVCBundleTag getLinkTargetEffectForNewLinkFrom(IMVCBundle linkSourceBundle) {
        Object srcModel = linkSourceBundle.getModel();
        if (srcModel instanceof ILayoutedModelElement && srcModel instanceof EObject) {
            EObject startModel = (EObject)srcModel;
            ILayoutedModelElement endModel = this.getLayoutedME();
            EObject root = (EObject)this.getViewer().getRootElement();
            IConnectionCompositorService srv = IConnectionCompositorService.getInstance();
            if (srv.canConnect(startModel, (EObject)endModel, root, null)) {
                return DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG;
            }
        }
        return DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG;
    }

    public MVCBundleTag getLinkTargetEffectForMoveLink(ILinkMVCBundle linkBundle, IAnchorageMVCBundle movedAnchorageBundle) {
        ILayoutedModelElement ownModel = this.getLayoutedME();
        return LWFXEditorUtils.getLinkTargetEffectForMoveLink(linkBundle, movedAnchorageBundle, ownModel);
    }
}

