/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Arrays;
import javafx.geometry.Point2D;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.ui.editor.fx.controller.LayoutedLinkBendPointController;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerFeatures;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class LayoutedCurveLinkBendPointController<T extends INamedCommentedElement & ILayoutedModelElement>
extends LayoutedLinkBendPointController<T> {
    public LayoutedCurveLinkBendPointController(ILinkMVCBundle mvcb, Class<T> modelType) {
        super(mvcb, modelType);
    }

    protected final void createBendPointAt(int bpIndex, DiagramCoordinate location) {
        DiagramViewerFeatures features = this.getViewer().getFeatures();
        Point c2 = LayoutModelElementFactory.createPoint((int)((int)(location.getX() - 2.0 * features.getHorizontalSpacing())), (int)((int)location.getY()), null);
        Point c1 = LayoutModelElementFactory.createPoint((int)((int)(location.getX() + 2.0 * features.getHorizontalSpacing())), (int)((int)location.getY()), null);
        Point bp = LayoutModelElementFactory.createPoint((int)((int)location.getX()), (int)((int)location.getY()), null);
        this.getBendPointList((ILayoutedModelElement)this.getModelElement()).addAll(bpIndex - 1, Arrays.asList(c2, bp, c1));
    }

    protected final void moveBendPointVisually(int bpIndex, Point2D delta) {
        super.moveBendPointVisually(bpIndex, delta);
        if (bpIndex <= 0 || bpIndex >= this.getNumerOfBendPoints() - 1) {
            return;
        }
        ILinkVisual linkVisual = this.getLinkVisual();
        FeedbackChange centerPointChange = this.getMoveDeltaFeedback(bpIndex, delta);
        int indexMod3 = bpIndex % 3;
        if (indexMod3 == 2) {
            linkVisual.setFeedbackChangeForBendPoint(bpIndex - 1, centerPointChange);
            linkVisual.setFeedbackChangeForBendPoint(bpIndex + 1, centerPointChange);
        } else {
            FeedbackChange inv = FeedbackChange.locationFeedbackChange((double)(-centerPointChange.getDeltaX()), (double)(-centerPointChange.getDeltaY()));
            int otherIndex = indexMod3 == 1 ? bpIndex + 2 : bpIndex - 2;
            linkVisual.setFeedbackChangeForBendPoint(otherIndex, inv);
        }
    }

    protected final void moveBendPointInModel(int bpIndex, Point2D delta) {
        FeedbackChange chg = this.getMoveDeltaFeedback(bpIndex, delta);
        this.getLinkVisual().setFeedbackChangeForBendPoint(bpIndex, null);
        this.updateModelAfterBendPointMove(bpIndex, chg.getDeltaX(), chg.getDeltaY());
        if (bpIndex <= 0 || bpIndex >= this.getNumerOfBendPoints() - 1) {
            return;
        }
        ILinkVisual linkVisual = this.getLinkVisual();
        int indexMod3 = bpIndex % 3;
        if (indexMod3 == 2) {
            linkVisual.setFeedbackChangeForBendPoint(bpIndex - 1, null);
            this.updateModelAfterBendPointMove(bpIndex - 1, chg.getDeltaX(), chg.getDeltaY());
            linkVisual.setFeedbackChangeForBendPoint(bpIndex + 1, null);
            this.updateModelAfterBendPointMove(bpIndex + 1, chg.getDeltaX(), chg.getDeltaY());
        } else {
            int otherIndex = indexMod3 == 1 ? bpIndex + 2 : bpIndex - 2;
            linkVisual.setFeedbackChangeForBendPoint(otherIndex, null);
            this.updateModelAfterBendPointMove(otherIndex, -chg.getDeltaX(), -chg.getDeltaY());
        }
    }
}

