/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Objects;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.editor.fx.controller.EObjectEllipticResizableContentControllerBase;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

public class LayoutedEllipticResizableContentController<T extends ILayoutedModelElement & INamedCommentedElement>
extends EObjectEllipticResizableContentControllerBase<T> {
    public LayoutedEllipticResizableContentController(IContentMVCBundle mvcb, Class<T> modelType) {
        super(mvcb, modelType);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected void moveAnchorageToAngle(IContentAnchorageMVCBundle anchorage, double angleInDegree) {
        Object connObj = anchorage.getModel();
        if (connObj instanceof IConnector && connObj instanceof ILayoutedModelElement) {
            ILayoutedModelElement conn = (ILayoutedModelElement)connObj;
            LayoutDataUtils.setConnectorAngle((ILayoutedModelElement)conn, (double)Math.toRadians(angleInDegree));
        }
    }

    protected void move(FeedbackChange deltaChange) {
        LayoutDataUtils.moveNode((ILayoutedModelElement)((ILayoutedModelElement)this.getModelElement()), (int)((int)deltaChange.getDeltaX()), (int)((int)deltaChange.getDeltaY()));
    }

    protected boolean allowLink() {
        return false;
    }

    protected void resize(FeedbackChange delta) {
        ILayoutedModelElement element = (ILayoutedModelElement)this.getModelElement();
        Dimension d = LayoutDataUtils.getNodeSize((ILayoutedModelElement)element);
        int w = d.getWidth() + (int)delta.getDeltaW();
        int h = d.getHeight() + (int)delta.getDeltaH();
        LayoutDataUtils.setNodeSize((ILayoutedModelElement)element, (int)w, (int)h);
    }
}

