/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.ui.editor.fx.controller.NamedCommentedLayoutModelChangeProvider;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.controller.base.LinkControllerBase;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelChangeProvider;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;

public abstract class LayoutedLinkBendPointController<T extends INamedCommentedElement & ILayoutedModelElement>
extends LinkControllerBase {
    protected final NamedCommentedLayoutModelChangeProvider<T> layoutModelChangeProvider;

    public T getModelElement() {
        return (T)((INamedCommentedElement)this.getModel());
    }

    public IModelChangeProvider getModelChangeProvider() {
        return this.layoutModelChangeProvider;
    }

    public LayoutedLinkBendPointController(ILinkMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
        INamedCommentedElement lme = (INamedCommentedElement)mvcb.getModel();
        this.layoutModelChangeProvider = new NamedCommentedLayoutModelChangeProvider<INamedCommentedElement>(lme);
    }

    public void delete() {
        this.deleteLink();
    }

    protected boolean clampAndSnapBendPointToGridCenter() {
        return false;
    }

    protected boolean clampAndSnapBendPointToGrid() {
        return true;
    }

    protected void deleteBendPoint(int bpIndex) {
        LayoutDataUtils.removeConnectionPoint((ILayoutedModelElement)((ILayoutedModelElement)this.getModelElement()), (int)bpIndex);
    }

    protected void updateModelAfterBendPointMove(int bpIndex, double dx, double dy) {
        EList<Point> oldPoints = this.getBendPointList((ILayoutedModelElement)this.getModelElement());
        Point point = (Point)oldPoints.get(bpIndex);
        int oldX = point.getX();
        int oldY = point.getY();
        int newX = oldX + (int)dx;
        int newY = oldY + (int)dy;
        point.setX(newX);
        point.setY(newY);
    }

    protected void deleteLink() {
        IConnectionCompositorService.getInstance().disconnect(this.getModelElement());
    }

    protected void updateModelAfterLinkMove(ILinkMVCBundle linkBundle, IMVCBundle startBundle, IMVCBundle endBundle) {
        EObject connectionObj = (EObject)linkBundle.getModel();
        EObject sourceObj = (EObject)startBundle.getModel();
        EObject targetObj = (EObject)endBundle.getModel();
        IConnectionCompositorService connectionService = IConnectionCompositorService.getInstance();
        if (connectionService.canReconnect(connectionObj, sourceObj, targetObj, null)) {
            connectionService.reconnect(connectionObj, sourceObj, targetObj, null);
            this.getViewer().updateFromModel();
        }
    }

    protected EList<Point> getBendPointList(ILayoutedModelElement modelElement) {
        return LayoutDataUtils.getConnectionPoints((ILayoutedModelElement)modelElement).getPoints();
    }

    protected int getNumerOfBendPoints() {
        return this.getBendPointList((ILayoutedModelElement)this.getModelElement()).size();
    }
}

