/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Objects;
import javafx.geometry.Dimension2D;
import javafx.geometry.Side;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ConnectionDragContext;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.ui.editor.fx.controller.EObjectRectangularResizableContentControllerBase;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.FeedbackChange;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.MVCBundleTag;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;

public class LayoutedRectangularResizableContentController<T extends INamedCommentedElement & ILayoutedModelElement>
extends EObjectRectangularResizableContentControllerBase<T> {
    public LayoutedRectangularResizableContentController(IContentMVCBundle mvcb, Class<T> modelType) {
        super(mvcb, modelType);
        Object model = Objects.requireNonNull(mvcb.getModel(), "The given model is null!");
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected void moveAnchorageToSideOffset(IContentAnchorageMVCBundle anchorage, Side side, double offset) {
        Object connObj = anchorage.getModel();
        if (connObj instanceof IConnector && connObj instanceof ILayoutedModelElement) {
            ILayoutedModelElement conn = (ILayoutedModelElement)connObj;
            Dimension2D portDim = anchorage.getVisual().getDimensions();
            int correction = side == Side.TOP || side == Side.BOTTOM ? (int)portDim.getWidth() / 2 : (int)portDim.getHeight() / 2;
            int corrected = (int)offset + correction;
            LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)conn, (EOrientation)LWFXEditorUtils.convertSideToEOrientation(side), (int)corrected);
        }
    }

    protected void move(FeedbackChange deltaChange) {
        LayoutDataUtils.moveNode((ILayoutedModelElement)((ILayoutedModelElement)this.getModelElement()), (int)((int)deltaChange.getDeltaX()), (int)((int)deltaChange.getDeltaY()));
    }

    protected void resize(FeedbackChange delta) {
        Object element = this.getModelElement();
        Dimension d = LayoutDataUtils.getNodeSize((ILayoutedModelElement)((ILayoutedModelElement)element));
        int w = d.getWidth() + (int)delta.getDeltaW();
        int h = d.getHeight() + (int)delta.getDeltaH();
        LayoutDataUtils.setNodeSize((ILayoutedModelElement)((ILayoutedModelElement)element), (int)w, (int)h);
    }

    protected void link(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        EObject start = (EObject)startBundle.getModel();
        EObject end = (EObject)endBundle.getModel();
        EObject root = (EObject)this.getViewer().getRootElement();
        Point startPoint = LWFXEditorUtils.convertDiagramCoordinateToPoint(startLocation);
        Point endPoint = LWFXEditorUtils.convertDiagramCoordinateToPoint(endLocation);
        boolean isSourceFreeConnector = false;
        boolean isSourceRoot = start == root;
        boolean isTargetFreeConnector = false;
        boolean isTargetRoot = end == root;
        ConnectionDragContext context = new ConnectionDragContext(start, start.eContainer(), startPoint, end, end.eContainer(), endPoint, isSourceFreeConnector, isSourceRoot, isTargetFreeConnector, isTargetRoot);
        IConnectionCompositorService.getInstance().connect(start, end, root, (IConnectionCompositionContext)context);
    }

    protected boolean canLink(IMVCBundle startBundle, DiagramCoordinate startLocation, IMVCBundle endBundle, DiagramCoordinate endLocation) {
        IConnectionCompositorService ccs = IConnectionCompositorService.getInstance();
        EObject start = (EObject)startBundle.getModel();
        EObject end = (EObject)endBundle.getModel();
        EObject root = (EObject)this.getViewer().getRootElement();
        return ccs.canConnect(start, end, root, null);
    }

    public MVCBundleTag getLinkTargetEffectForNewLinkFrom(IMVCBundle linkSourceBundle) {
        Object srcModel = linkSourceBundle.getModel();
        if (srcModel instanceof ILayoutedModelElement && srcModel instanceof EObject) {
            EObject startModel = (EObject)srcModel;
            ILayoutedModelElement endModel = (ILayoutedModelElement)this.getModelElement();
            EObject root = (EObject)this.getViewer().getRootElement();
            IConnectionCompositorService srv = IConnectionCompositorService.getInstance();
            if (srv.canConnect(startModel, (EObject)endModel, root, null)) {
                return DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG;
            }
        }
        return DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG;
    }

    public boolean isPossibleLinkTarget() {
        return false;
    }
}

