/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

public abstract class ModelElementFXEditorUIProviderBase<T extends IModelElement>
extends DynamicTreeTableUIProviderBase<T> {
    protected final FXEditorBase<?> editor;

    public ModelElementFXEditorUIProviderBase(FXEditorBase<?> editor) {
        this.editor = editor;
    }

    public Node getIconNode(IModelElement element, int column) {
        if (element == null) {
            return null;
        }
        return IModelElementHandlerService.getInstance().getFXIcon((EObject)element);
    }

    public ContextMenu createContextMenu(IModelElement element, int column) {
        if (element == null || column != 0) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll(ContextMenuUtils.createPrototypeMenu((EObject)element, null));
        contextMenu.getItems().addAll((Collection)IContextMenuService.getInstance().getFXMenuItemsForElement((EObject)element, null));
        return contextMenu;
    }

    public void select(IModelElement oldValue, IModelElement newValue) {
        StructuredSelection selection = newValue == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)newValue);
        this.editor.getSite().getSelectionProvider().setSelection((ISelection)selection);
    }
}

