/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.controller;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.LayoutPackage;
import org.fortiss.tooling.base.ui.editor.fx.controller.KernelServiceBasedModelChangeProviderBase;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;

class NamedCommentedLayoutModelChangeProvider<T extends INamedCommentedElement & ILayoutedModelElement>
extends KernelServiceBasedModelChangeProviderBase<T> {
    private final T modelElement;
    private final LayoutModelElementAdapter notificationListener;

    public NamedCommentedLayoutModelChangeProvider(T modelElement) {
        this.modelElement = modelElement;
        this.notificationListener = new LayoutModelElementAdapter();
    }

    @Override
    protected T getModelElement() {
        return this.modelElement;
    }

    @Override
    protected Adapter getNotificationListener() {
        return this.notificationListener;
    }

    protected boolean acceptNotification(Notification notification) {
        return false;
    }

    public class LayoutModelElementAdapter
    extends EContentAdapter {
        public void notifyChanged(Notification notification) {
            if (NamedCommentedLayoutModelChangeProvider.this.acceptNotification(notification)) {
                NamedCommentedLayoutModelChangeProvider.this.addNotification(notification);
                return;
            }
            Object notifier = notification.getNotifier();
            if (notifier == NamedCommentedLayoutModelChangeProvider.this.modelElement) {
                Object feature = notification.getFeature();
                if (feature == FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME || feature == FortissToolingKernelPackage.Literals.INAMED_COMMENTED_ELEMENT__COMMENT) {
                    NamedCommentedLayoutModelChangeProvider.this.addNotification(notification);
                    return;
                }
                if (feature == LayoutPackage.Literals.ILAYOUTED_MODEL_ELEMENT__LAYOUT_DATA) {
                    super.notifyChanged(notification);
                    NamedCommentedLayoutModelChangeProvider.this.addNotification(notification);
                    return;
                }
            } else if (notifier instanceof ILayoutData) {
                super.notifyChanged(notification);
                NamedCommentedLayoutModelChangeProvider.this.addNotification(notification);
                return;
            }
        }

        protected void layoutChanged() {
        }

        protected void selfAdapt(Notification notification) {
            if (notification.getNotifier() instanceof EObject) {
                super.selfAdapt(notification);
            }
        }

        protected void handleContainment(Notification notification) {
            if (notification.getNotifier() instanceof ILayoutData) {
                super.handleContainment(notification);
                return;
            }
            Class instanceClass = LayoutPackage.Literals.ILAYOUTED_MODEL_ELEMENT.getInstanceClass();
            if (notification.getFeatureID(instanceClass) == 0) {
                super.handleContainment(notification);
            }
        }
    }
}

