/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.IModelFactory;
import org.fortiss.tooling.common.util.LambdaUtils;

public abstract class HierarchicElementModelFactoryBase<T extends IHierarchicElement>
implements IModelFactory {
    private final T rootElement;

    public HierarchicElementModelFactoryBase(T root) {
        this.rootElement = (IHierarchicElement)Objects.requireNonNull(root);
    }

    public T getRootModel() {
        return this.rootElement;
    }

    public List<?> getDiagramAnchorageModels() {
        return this.rootElement.getConnectors();
    }

    public List<?> getContentAnchorageModels(Object parent) {
        if (parent instanceof IHierarchicElement) {
            return ((IHierarchicElement)parent).getConnectors();
        }
        return Collections.emptyList();
    }

    public List<?> getLinkModels() {
        return LambdaUtils.filterList((Collection)this.rootElement.getConnections(), c -> this.filterPartiallyInitializedConnections((IConnection)c));
    }

    private boolean filterPartiallyInitializedConnections(IConnection c) {
        return c.getSource() != null && c.getTarget() != null && c.eContainer() != null;
    }

    public Object getLinkStart(Object link) {
        if (link instanceof IConnection) {
            return ((IConnection)link).getSource();
        }
        return null;
    }

    public Object getLinkEnd(Object link) {
        if (link instanceof IConnection) {
            return ((IConnection)link).getTarget();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public void update() {
    }
}

