/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.widgets.AlignedText;

class AnchorageText {
    AlignedText nameText = new AlignedText();

    public AnchorageText() {
        this.nameText.setMouseTransparent(true);
    }

    public <V extends IAnchorageVisual & ISideLayout> void updateNodes(V visual, IConnector connector, String text, DiagramLayers layers) {
        this.nameText.setText(text);
        this.updateNameTextPosition(visual, connector);
        if (this.nameText.getParent() == null) {
            layers.getVisualFeedbackLayer().add((Node)this.nameText, visual.getMVCBundle());
        }
    }

    private <V extends IAnchorageVisual & ISideLayout> void updateNameTextPosition(V visual, IConnector connector) {
        Rectangle2D bounds = visual.getCurrentBounds();
        switch (((ISideLayout)visual).getSide()) {
            case LEFT: {
                if (LWFXEditorUtils.stickyConnectorHasVisibleConnections(connector)) {
                    this.nameText.setX(bounds.getMinX() + bounds.getWidth() / 4.0);
                    this.nameText.setY(bounds.getMinY() + bounds.getHeight() / 4.0);
                    this.nameText.setAlignment(Pos.BOTTOM_RIGHT);
                    break;
                }
                this.nameText.setX(bounds.getMinX());
                this.nameText.setY(bounds.getMinY() + bounds.getHeight() / 2.0);
                this.nameText.setAlignment(Pos.CENTER_RIGHT);
                break;
            }
            case RIGHT: {
                if (LWFXEditorUtils.stickyConnectorHasVisibleConnections(connector)) {
                    this.nameText.setX(bounds.getMaxX() - bounds.getWidth() / 4.0);
                    this.nameText.setY(bounds.getMinY() + bounds.getHeight() / 4.0);
                    this.nameText.setAlignment(Pos.BOTTOM_LEFT);
                    break;
                }
                this.nameText.setX(bounds.getMaxX());
                this.nameText.setY(bounds.getMinY() + bounds.getHeight() / 2.0);
                this.nameText.setAlignment(Pos.CENTER_LEFT);
                break;
            }
            case TOP: {
                this.nameText.setX(bounds.getMaxX());
                this.nameText.setY(bounds.getMinY());
                this.nameText.setAlignment(Pos.BOTTOM_CENTER);
                break;
            }
            case BOTTOM: {
                this.nameText.setX(bounds.getMaxX());
                this.nameText.setY(bounds.getMaxY());
                this.nameText.setAlignment(Pos.TOP_CENTER);
            }
        }
    }

    public void removeAllVisuals(DiagramLayers layers) {
        if (this.nameText.getParent() != null) {
            layers.getVisualFeedbackLayer().remove((Node)this.nameText);
        }
    }

    public <V extends IContentVisual & ISideLayout> void updateNodes(V visual, String text, DiagramLayers layers) {
        this.nameText.setText(text);
        this.updateAnnotationTextPosition(visual);
        if (this.nameText.getParent() == null) {
            layers.getVisualFeedbackLayer().add((Node)this.nameText, visual.getMVCBundle());
        }
    }

    private <V extends IContentVisual & ISideLayout> void updateAnnotationTextPosition(V visual) {
        Rectangle2D bounds = visual.getCurrentBounds();
        this.nameText.setX(bounds.getMaxX() - bounds.getWidth() / 2.0);
        this.nameText.setY(bounds.getMinY());
        this.nameText.setAlignment(Pos.BOTTOM_CENTER);
    }
}

