/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import javafx.geometry.Dimension2D;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.ui.editor.fx.visual.CoordinateCorrections;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IAngleLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ILayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IOffsetLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.elliptic.CircularContentAnchorageVisualBase;

public abstract class LayoutedCircularAnchorageContentVisualBase<T extends ILayoutedModelElement>
extends CircularContentAnchorageVisualBase
implements ISideLayout,
IOffsetLayout,
IAngleLayout {
    public LayoutedCircularAnchorageContentVisualBase(IContentAnchorageMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = mvcb.getModel();
        if (model == null) {
            throw new IllegalArgumentException("The given model is null!");
        }
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected T getModelElement() {
        return (T)((ILayoutedModelElement)this.getModel());
    }

    public <S extends ILayout> S getLayout(Class<S> type) {
        return (S)((Object)this);
    }

    public Rectangle2D getModelBounds() {
        Point2D locOnParent = this.getLocationOnParent();
        Dimension2D dim = this.getDimensions();
        return new Rectangle2D(locOnParent.getX(), locOnParent.getY(), dim.getWidth(), dim.getHeight());
    }

    public Dimension2D getDimensions() {
        return CoordinateCorrections.ANCHOR_DIMENSION;
    }

    protected double getInset() {
        return 5.333333333333333;
    }

    public double getOffset() {
        OffsetOrientation offsetOrientation = LayoutDataUtils.getConnectorOffsetOrientation(this.getModelElement());
        double inset = this.getDimensions().getWidth() / 2.0;
        return (double)offsetOrientation.getOffset() - inset;
    }

    public Side getSide() {
        OffsetOrientation offsetOrientation = LayoutDataUtils.getConnectorOffsetOrientation(this.getModelElement());
        EOrientation orientation = EOrientation.NORTH;
        if (offsetOrientation != null) {
            orientation = offsetOrientation.getOrientation();
        }
        return LWFXEditorUtils.convertEOrientationToSide(orientation);
    }

    protected Paint getBorderColor() {
        return Color.BLACK;
    }

    protected double getOpacity() {
        return 1.0;
    }

    protected double getBorderWidth() {
        return 1.0;
    }

    protected Color getInteractionColor() {
        IContentAnchorageMVCBundle mvcBundle = this.getMVCBundle();
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG)) {
            return LWFXEditorUtils.LINK_DENIED_COLOR;
        }
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG)) {
            return LWFXEditorUtils.LINK_ALLOWED_COLOR;
        }
        return super.getInteractionColor();
    }

    public double getAngleInDegree() {
        return 360.0 - Math.toDegrees(LayoutDataUtils.getConnectorAngleAsDouble(this.getModelElement()));
    }
}

