/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import java.util.Collections;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import org.eclipse.emf.common.util.EList;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.LineLinkVisualBase;

public class LayoutedLineLinkVisual<T extends ILayoutedModelElement>
extends LineLinkVisualBase {
    public LayoutedLineLinkVisual(ILinkMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = mvcb.getModel();
        if (model == null) {
            throw new IllegalArgumentException("The given model is null!");
        }
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected T getModelElement() {
        return (T)((ILayoutedModelElement)this.getModel());
    }

    public DiagramCoordinate getBendPointLocation(int bpIndex) {
        Point point = this.getBendPointList().get(bpIndex);
        return new DiagramCoordinate((double)point.getX(), (double)point.getY());
    }

    protected DiagramCoordinate getStartAnchorLocation(Rectangle2D anchorBounds, DiagramCoordinate target) {
        return LWFXEditorUtils.computeLinkToCircleLocation(anchorBounds, (Point2D)target);
    }

    protected DiagramCoordinate getEndAnchorLocation(Rectangle2D anchorBounds, DiagramCoordinate target) {
        return LWFXEditorUtils.computeLinkToCircleLocation(anchorBounds, (Point2D)target);
    }

    protected Object getBendPointModel(int i) {
        return this.getBendPointList().get(i);
    }

    protected int getNumberOfBendPoints() {
        return this.getBendPointList().size();
    }

    private List<Point> getBendPointList() {
        Points connectionPoints = LayoutDataUtils.getConnectionPoints(this.getModelElement());
        if (connectionPoints == null) {
            return Collections.emptyList();
        }
        EList pointList = connectionPoints.getPoints();
        if (pointList == null) {
            return Collections.emptyList();
        }
        return pointList;
    }

    protected boolean showArrowOnLastSegment() {
        return true;
    }

    protected double getInvisibleSelectionLineWidth() {
        return 3.0;
    }
}

