/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.ui.editor.fx.visual.CoordinateCorrections;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramViewerDefaultTags;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularDiagramAnchorageVisualBase;

public abstract class LayoutedRectangularAnchorageDiagramVisualBase<T extends ILayoutedModelElement>
extends RectangularDiagramAnchorageVisualBase {
    public LayoutedRectangularAnchorageDiagramVisualBase(IDiagramAnchorageMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = mvcb.getModel();
        if (model == null) {
            throw new IllegalArgumentException("The given model is null!");
        }
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected T getModelElement() {
        return (T)((ILayoutedModelElement)this.getModel());
    }

    public Rectangle2D getModelBounds() {
        Point p = LayoutDataUtils.getNodePosition(this.getModelElement());
        Dimension2D dim = this.getDimensions();
        return new Rectangle2D((double)p.getX(), (double)p.getY(), dim.getWidth(), dim.getHeight());
    }

    public Dimension2D getDimensions() {
        return CoordinateCorrections.ANCHOR_DIMENSION;
    }

    protected Insets getInsets() {
        return new Insets(5.333333333333333);
    }

    protected Paint getBorderColor() {
        return Color.BLACK;
    }

    protected double getOpacity() {
        return 1.0;
    }

    protected double getBorderWidth() {
        return 1.0;
    }

    protected Color getInteractionColor() {
        IDiagramAnchorageMVCBundle mvcBundle = this.getMVCBundle();
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_DENIED_TAG)) {
            return LWFXEditorUtils.LINK_DENIED_COLOR;
        }
        if (mvcBundle.hasTag(DiagramViewerDefaultTags.LINK_TARGET_ALLOWED_TAG)) {
            return LWFXEditorUtils.LINK_ALLOWED_COLOR;
        }
        return super.getInteractionColor();
    }
}

