/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.geometry.Side;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Rectangle;
import org.fortiss.tooling.base.ui.editor.fx.visual.CoordinateCorrections;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramCoordinate;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.IOffsetLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.model.layout.ISideLayout;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularBorderLocation;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.rectangular.RectangularContentVisualBase;

public class LayoutedRectangularAnchorageItemVisualBase<T extends ILayoutedModelElement>
extends RectangularContentVisualBase
implements ISideLayout {
    public LayoutedRectangularAnchorageItemVisualBase(IContentMVCBundle mvcb, Class<T> modelType) {
        super(mvcb);
        Object model = mvcb.getModel();
        if (model == null) {
            throw new IllegalArgumentException("The given model is null!");
        }
        if (!modelType.isAssignableFrom(model.getClass())) {
            throw new IllegalArgumentException("Expected model of type " + modelType.getSimpleName() + ", but was " + model.getClass().getSimpleName());
        }
    }

    protected T getModelElement() {
        return (T)((ILayoutedModelElement)this.getModel());
    }

    public Rectangle2D getModelBounds() {
        Rectangle rectangle = LayoutDataUtils.getNodeBounds(this.getModelElement());
        double insetRadius = CoordinateCorrections.RECTANGLE_INSETS.getWidth();
        double insetDiameter = insetRadius * 2.0;
        return new Rectangle2D((double)rectangle.getX() + insetRadius, (double)rectangle.getY() + insetRadius, (double)rectangle.getWidth() - insetDiameter, (double)rectangle.getHeight() - insetDiameter);
    }

    public DiagramCoordinate getAnchorageLocation(IContentAnchorageVisual visual) {
        Rectangle2D contentRectangle = this.getCurrentBounds();
        Side rectangleSide = ((ISideLayout)visual.getLayout(ISideLayout.class)).getSide();
        double sideOffset = ((IOffsetLayout)visual.getLayout(IOffsetLayout.class)).getOffset();
        Dimension2D anchorageDimensions = visual.getDimensions();
        DiagramCoordinate location = new RectangularBorderLocation(rectangleSide, sideOffset, contentRectangle, anchorageDimensions).getLocation();
        double x = Math.min(location.getX(), contentRectangle.getWidth() - anchorageDimensions.getWidth() / 2.0);
        double y = Math.min(location.getY(), contentRectangle.getHeight() - anchorageDimensions.getHeight() / 2.0);
        return new DiagramCoordinate(x, y);
    }

    protected double getBorderWidth() {
        return 1.0;
    }

    protected double getOpacity() {
        return 1.0;
    }

    protected boolean requireSelectionForMoveGesture() {
        return false;
    }

    protected boolean requireSelectionForResizeGesture() {
        return false;
    }

    public Side getSide() {
        OffsetOrientation offsetOrientation = LayoutDataUtils.getConnectorOffsetOrientation(this.getModelElement());
        EOrientation orientation = EOrientation.NORTH;
        if (offsetOrientation != null) {
            orientation = offsetOrientation.getOrientation();
        }
        return LWFXEditorUtils.convertEOrientationToSide(orientation);
    }
}

