/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.editor.fx.visual.LayoutedRectangularAnchorageDiagramVisualBase;
import org.fortiss.tooling.base.ui.utils.LWFXEditorUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IMVCBundle;
import org.fortiss.tooling.kernel.model.INamedElement;

public class NamedLayoutedRectangularAnchorageDiagramVisual<T extends ILayoutedModelElement & INamedElement>
extends LayoutedRectangularAnchorageDiagramVisualBase<T> {
    private final Text nameText = new Text("");

    public NamedLayoutedRectangularAnchorageDiagramVisual(IDiagramAnchorageMVCBundle mvcb, Class<T> modelType) {
        super(mvcb, modelType);
        this.nameText.setMouseTransparent(true);
        this.nameText.setTextAlignment(TextAlignment.LEFT);
        this.nameText.setTextOrigin(VPos.CENTER);
    }

    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        if (this.enableName()) {
            Rectangle2D bounds = this.getCurrentBounds();
            this.nameText.setX(bounds.getMaxX());
            this.nameText.setY(bounds.getMinY() + bounds.getHeight() / 2.0);
            this.nameText.setText(this.getName());
            if (this.nameText.getParent() == null) {
                layers.getVisualFeedbackLayer().add((Node)this.nameText, (IMVCBundle)this.getMVCBundle());
            }
        } else if (this.nameText.getParent() != null) {
            layers.getVisualFeedbackLayer().remove((Node)this.nameText);
        }
    }

    public void removeAllVisuals(DiagramLayers layers) {
        super.removeAllVisuals(layers);
        if (this.nameText.getParent() != null) {
            layers.getVisualFeedbackLayer().remove((Node)this.nameText);
        }
    }

    public boolean enableName() {
        return !LWFXEditorUtils.freeConnectorHasVisibleConnections((IConnector)this.getModelElement());
    }

    public String getName() {
        return ((INamedElement)this.getModelElement()).getName();
    }
}

