/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.editor.fx.visual;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.fortiss.tooling.base.model.base.DerivedAnnotationBase;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.impl.PointImpl;
import org.fortiss.tooling.base.ui.editor.fx.visual.AnchorageText;
import org.fortiss.tooling.base.ui.editor.fx.visual.LayoutedRectangularAnchorageItemVisualBase;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.DiagramLayers;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class NamedLayoutedRectangularAnchorageItemVisual<T extends INamedElement & ILayoutedModelElement>
extends LayoutedRectangularAnchorageItemVisualBase<T> {
    private final AnchorageText nameText = new AnchorageText();
    private Class<? extends IAnnotatedSpecification> annotationUpdateType;
    private Class<? extends IAnnotatedSpecification> decorationUpdateType;

    public NamedLayoutedRectangularAnchorageItemVisual(IContentMVCBundle mvcb, Class<T> modelType, Class<? extends IAnnotatedSpecification> annotationUpdateType, Class<? extends IAnnotatedSpecification> decorationUpdateType) {
        super(mvcb, modelType);
        this.annotationUpdateType = annotationUpdateType;
        this.decorationUpdateType = decorationUpdateType;
    }

    protected String getName() {
        return ((INamedElement)this.getModelElement()).getName();
    }

    private String getDecorationText() {
        INamedElement item = (INamedElement)this.getModelElement();
        EList specifications = ((IModelElement)item).getSpecifications();
        if (specifications == null || specifications.size() == 0 || specifications.get(0) == null) {
            return "";
        }
        DerivedAnnotationBase decorationAnnotation = (DerivedAnnotationBase)EcoreUtils.pickFirstInstanceOf(this.decorationUpdateType, (List)specifications);
        String decorationText = (String)decorationAnnotation.getValue();
        if (decorationText == null) {
            return "";
        }
        return decorationText;
    }

    private void updatePositionInAnnotation() {
        INamedElement item = (INamedElement)this.getModelElement();
        String annotatedPosition = (String)AnnotationUtils.getAnnotationValue((IModelElement)((IModelElement)item), this.annotationUpdateType, String.class);
        ILayoutData layoutData = (ILayoutData)((ILayoutedModelElement)item).getLayoutData().get(0);
        PointImpl x = (PointImpl)layoutData;
        String layoutPosition = "[" + x.getX() + ", " + x.getY() + "]";
        if (annotatedPosition == null || !annotatedPosition.equals(layoutPosition)) {
            try {
                AnnotationUtils.setAnnotationValue((IModelElement)((IModelElement)item), this.annotationUpdateType, (Object)layoutPosition);
            }
            catch (Exception e) {
                throw new RuntimeException("Annotation update failed. Please try again.");
            }
        }
    }

    public void updateNodes(DiagramLayers layers) {
        super.updateNodes(layers);
        this.nameText.updateNodes(this, this.getDecorationText(), layers);
        this.updatePositionInAnnotation();
    }
}

