/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.fieldassist;

import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssistImageRegistry;
import org.fortiss.tooling.base.ui.fieldassist.IProposalProvider;
import org.fortiss.tooling.base.ui.fieldassist.StaticProposalProvider;

public class FieldAssist {
    private final Text field;
    private IProposalProvider concreteProvider;
    private AF3ContentProposalProvider provider;
    private ContentProposalAdapter adapter;

    public FieldAssist(Text field, IProposalProvider provider) {
        this.field = field;
        this.provider = new AF3ContentProposalProvider(provider);
        this.initialize();
    }

    private void initialize() {
        this.provider.setFiltering(true);
        this.adapter = new ContentProposalAdapter((Control)this.field, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.provider, this.concreteProvider.getKeystroke(), this.concreteProvider.getAutoActivationChars());
        this.adapter.setPropagateKeys(true);
        this.adapter.setProposalAcceptanceStyle(3);
        this.adapter.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IContentProposal) {
                    IContentProposal prop = (IContentProposal)element;
                    if (prop.getLabel() == null) {
                        return prop.getContent();
                    }
                    return prop.getLabel();
                }
                return element.toString();
            }

            public Image getImage(Object element) {
                return FieldAssistImageRegistry.getIcon(this.getText(element));
            }
        });
        this.adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                int end = FieldAssist.this.field.getCaretPosition();
                int start = FieldAssist.this.findBeginningOfWord(FieldAssist.this.field.getText(), end);
                String newContents = FieldAssist.this.field.getText().substring(0, Math.max(0, start + 1));
                newContents = newContents.concat(proposal.getContent());
                int min = Math.min(FieldAssist.this.field.getText().length(), end);
                newContents = newContents.concat(FieldAssist.this.field.getText().substring(min));
                FieldAssist.this.field.setText(newContents);
                FieldAssist.this.field.setSelection(start + proposal.getContent().length() + 1);
            }
        });
    }

    public void setProposalProvider(IProposalProvider proposalProvider) {
        this.provider = new AF3ContentProposalProvider(proposalProvider);
        this.provider.setFiltering(true);
        this.adapter.setContentProposalProvider((IContentProposalProvider)this.provider);
    }

    private int findBeginningOfWord(String contents, int position) {
        if (contents.isEmpty()) {
            return -1;
        }
        int tmp = position - 1;
        while (tmp >= 0 && !Character.isWhitespace(contents.charAt(tmp)) && !this.isAdditionalWhitespace(contents.charAt(tmp))) {
            --tmp;
        }
        return tmp;
    }

    private boolean isAdditionalWhitespace(char charAt) {
        char[] cArray = this.concreteProvider.getAdditionalWhitespaceChars();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == charAt) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private final class AF3ContentProposalProvider
    extends SimpleContentProposalProvider {
        public AF3ContentProposalProvider(String[] proposals) {
            super(proposals);
            FieldAssist.this.concreteProvider = new StaticProposalProvider(proposals);
        }

        public AF3ContentProposalProvider(IProposalProvider provider) {
            super(new String[0]);
            FieldAssist.this.concreteProvider = provider;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            int tmp = FieldAssist.this.findBeginningOfWord(contents, position);
            String currentWord = contents.substring(tmp + 1, position);
            this.setProposals(FieldAssist.this.concreteProvider.getProposals(currentWord));
            return super.getProposals(currentWord, position);
        }
    }
}

