/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.javafx.control.treetableview;

import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeItemBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeViewer;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.util.KernelUIUtils;
import patched.javafx.embed.swt.SWTFXUtils;

public class ModelElementTreeViewer<T extends INamedElement> {
    protected DynamicTreeViewer<T> dynTreeViewer;

    public ModelElementTreeViewer(TreeView<T> treeView, T modelRoot, DynamicTreeContentProviderBase<T> contentProvider) {
        this(treeView, modelRoot, true, 0, contentProvider);
    }

    public ModelElementTreeViewer(TreeView<T> treeView, T modelRoot, boolean showRoot, int revealLevel, DynamicTreeContentProviderBase<T> contentProvider) {
        DynamicTreeUIProviderBase<T> uiProvider = this.createUIProvider();
        this.dynTreeViewer = new DynamicTreeViewer(treeView, modelRoot, showRoot, revealLevel, contentProvider, uiProvider);
    }

    protected DynamicTreeUIProviderBase<T> createUIProvider() {
        return new ModelElementUIProvider();
    }

    public void update() {
        this.dynTreeViewer.update();
    }

    public void expandItem(T value) {
        DynamicTreeItemBase item = this.dynTreeViewer.findItem(value);
        this.dynTreeViewer.expandItem((TreeItem)item);
    }

    public void collapseItem(T value) {
        DynamicTreeItemBase<T> item = this.findItem(value);
        this.dynTreeViewer.collapseItem(item);
    }

    public DynamicTreeItemBase<T> findItem(T value) {
        return this.dynTreeViewer.findItem(value);
    }

    protected class ModelElementUIProvider
    extends DynamicTreeUIProviderBase<T> {
        protected ModelElementUIProvider() {
        }

        public String getLabel(T element) {
            return KernelUIUtils.getName(element);
        }

        public Node getIconNode(T element) {
            Image icon = IModelElementHandlerService.getInstance().getIcon(element);
            if (icon != null) {
                WritableImage fxImage = SWTFXUtils.toFXImage((ImageData)icon.getImageData(), null);
                return new ImageView((javafx.scene.image.Image)fxImage);
            }
            return null;
        }
    }
}

