/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.layout.auto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.tooling.base.layout.KielerAutoLayouter;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.ui.ToolingBaseUIActivator;
import org.fortiss.tooling.base.utils.AngleUtils;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.IModelElementHandler;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class AutoLayoutMenu
implements IContextMenuContributor {
    private static String MENU_NAME = "Automatic layout";
    private static String MENU_ICON = "icons/autolayout.png";

    protected ImageDescriptor getActionIcon() {
        return ToolingBaseUIActivator.getImageDescriptor(MENU_ICON);
    }

    private boolean hasConnectedConnectorWithAngle(IHierarchicElement element) {
        for (ILayoutedModelElement conLayouted : EcoreUtils.pickInstanceOf(ILayoutedModelElement.class, (List)element.getConnectors())) {
            if (AngleUtils.getAngle((ILayoutedModelElement)conLayouted, (String)"cangle") == null) continue;
            IConnector connector = (IConnector)conLayouted;
            return !connector.getIncoming().isEmpty() || !connector.getOutgoing().isEmpty();
        }
        return false;
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        IModelElementHandler handler = IModelElementHandlerService.getInstance().getModelElementHandler(selection);
        if (handler == null) {
            return Collections.emptyList();
        }
        EObject editedObject = handler.handleOpenModelElementRequest(selection);
        if (!(editedObject instanceof IHierarchicElement)) {
            return Collections.emptyList();
        }
        IHierarchicElement element = (IHierarchicElement)editedObject;
        if (EcoreUtils.pickInstanceOf(ILayoutedModelElement.class, (List)element.getContainedElements()).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.hasConnectedConnectorWithAngle(element)) {
            return Collections.emptyList();
        }
        for (IHierarchicElement childElement : element.getContainedElements()) {
            if (!this.hasConnectedConnectorWithAngle(childElement)) continue;
            return Collections.emptyList();
        }
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        contributionItems.add((IContributionItem)new ActionContributionItem((IAction)new LaunchAutoLayoutAction(element)));
        return contributionItems;
    }

    public String getMenuSectionID() {
        return null;
    }

    protected class LaunchAutoLayoutAction
    extends Action {
        private final IHierarchicElement element;

        public LaunchAutoLayoutAction(IHierarchicElement recGraph) {
            super(MENU_NAME, AutoLayoutMenu.this.getActionIcon());
            this.element = recGraph;
        }

        public void run() {
            KernelModelElementUtils.runAsCommand((EObject)this.element, () -> {
                KielerAutoLayouter layouter = new KielerAutoLayouter();
                layouter.performAutoLayout(this.element);
            });
        }
    }
}

