/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;

public abstract class AbstractNameEditingSupport
extends EditingSupport {
    public AbstractNameEditingSupport(ColumnViewer viewer) {
        super(viewer);
    }

    protected abstract INamedElement[] getSiblingsForUniqueNameCheck(INamedElement var1);

    protected void setValue(Object element, final Object value) {
        final INamedElement elt = (INamedElement)element;
        if (value != null && !value.toString().equals(elt.getName())) {
            INamedElement[] iNamedElementArray = this.getSiblingsForUniqueNameCheck(elt);
            int n = iNamedElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                INamedElement child = iNamedElementArray[n2];
                if (child != element && value.equals(child.getName())) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"This name already exists, please choose another one.");
                    return;
                }
                ++n2;
            }
            ICommandStackService.getInstance().runAsCommand((EObject)elt, new Runnable(){

                @Override
                public void run() {
                    AbstractNameEditingSupport.this.setValueInternal(value, elt);
                }
            });
        }
    }

    protected void setValueInternal(Object value, INamedElement elt) {
        elt.setName(value.toString());
    }

    protected Object getValue(Object element) {
        return ((INamedElement)element).getName();
    }

    protected CellEditor getCellEditor(Object element) {
        return new TextCellEditor((Composite)this.getViewer().getControl());
    }

    protected boolean canEdit(Object element) {
        return element instanceof INamedElement;
    }
}

