/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.layout.KielerAutoLayouter;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPrototypeService;
import org.fortiss.tooling.kernel.ui.extension.IModelEditor;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

public final class ContextMenuUtils {
    public static List<MenuItem> createPrototypeMenu(EObject target, IElementCompositionContext context, boolean onlyForEditedObject) {
        MenuItem menuItem;
        EObject prototypeCopy;
        IPrototypeService pers = IPrototypeService.getInstance();
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        IModelEditor activeEditor = IModelEditorBindingService.getInstance().getActiveEditor();
        boolean isMenuForEditedObject = activeEditor != null && target == activeEditor.getEditedObject();
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        Menu newMenu = new Menu("New ...");
        Menu reuseMenu = new Menu("Reuse ...");
        List prototypes = pers.getComposablePrototypes(target.getClass());
        ArrayList<Prototype> prototypesForNewMenu = new ArrayList<Prototype>();
        for (Prototype prototype : prototypes) {
            prototypeCopy = prototype.getPrototypeCopy();
            if (onlyForEditedObject && !isMenuForEditedObject && !(prototypeCopy instanceof IConnector) || !ecs.canCompose(target, prototypeCopy, context)) continue;
            if (ReuseLibraryUtilsBasics.isCorrectReuseElement((EObject)prototypeCopy)) {
                menuItem = ContextMenuUtils.createMenuItemForComposableElement(prototypeCopy, target, context, prototype.getName());
                String libraryName = ReuseLibraryUtilsBasics.getNameOfFirstRelatedLibrary((EObject)prototypeCopy);
                menuItem.setText("[" + libraryName + "] " + prototype.getName());
                menuItem.setMnemonicParsing(false);
                reuseMenu.getItems().add((Object)menuItem);
                continue;
            }
            prototypesForNewMenu.add(prototype);
        }
        prototypesForNewMenu.sort(new Comparator<Prototype>(){

            @Override
            public int compare(Prototype prototype1, Prototype prototype2) {
                int result = prototype1.getPriority() - prototype2.getPriority();
                if (result == 0) {
                    result = -prototype1.getName().compareTo(prototype2.getName());
                }
                return result;
            }
        });
        Collections.reverse(prototypesForNewMenu);
        for (Prototype prototype : prototypesForNewMenu) {
            prototypeCopy = prototype.getPrototypeCopy();
            menuItem = ContextMenuUtils.createMenuItemForComposableElement(prototypeCopy, target, context, prototype.getName());
            menuItem.setMnemonicParsing(false);
            newMenu.getItems().add((Object)menuItem);
        }
        if (!newMenu.getItems().isEmpty()) {
            result.add((MenuItem)newMenu);
        }
        if (!reuseMenu.getItems().isEmpty()) {
            result.add((MenuItem)reuseMenu);
        }
        return result;
    }

    private static MenuItem createMenuItemForComposableElement(EObject composableElement, EObject target, IElementCompositionContext context, String itemName) {
        ICommandStackService css = ICommandStackService.getInstance();
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        MenuItem menuItem = new MenuItem(itemName);
        menuItem.setOnAction(evt -> css.runAsCommand(target, () -> ecs.compose(target, composableElement, context)));
        return menuItem;
    }

    public static List<MenuItem> createPrototypeMenu(EObject target, IElementCompositionContext context) {
        return ContextMenuUtils.createPrototypeMenu(target, context, true);
    }

    public static MenuItem createDeleteMenu(EObject target) {
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        ICommandStackService css = ICommandStackService.getInstance();
        MenuItem deleteMenuItem = new MenuItem("Delete");
        deleteMenuItem.setOnAction(evt -> css.runAsCommand(target, () -> ecs.decompose(target)));
        return deleteMenuItem;
    }

    public static MenuItem createAutoLayoutMenu(IHierarchicElement target) {
        String MENU_NAME = "Automatic layout";
        MenuItem mi = new MenuItem("Automatic layout");
        ICommandStackService css = ICommandStackService.getInstance();
        mi.setOnAction(evt -> css.runAsCommand((EObject)target, () -> {
            KielerAutoLayouter layouter = new KielerAutoLayouter();
            layouter.performAutoLayout(target);
        }));
        return mi;
    }

    public static IElementCompositionContext createElementCompositionContext(EObject target, double x, double y, boolean isRoot, double zoom) {
        Point loc = LayoutModelElementFactory.createPoint((int)((int)x), (int)((int)y), (String)"CompositionPoint");
        return new ElementDropContext(target, loc, isRoot, zoom);
    }
}

