/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.ui.utils;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.EllipseLayoutUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public final class EllipseLayoutUIUtils {
    private static Point calculateEllipseBorderPoint(double angle, Dimension ellipseSize, int inset) {
        org.fortiss.tooling.base.model.layout.Dimension ellipseSizeElement = LayoutModelElementFactory.createDimension((int)ellipseSize.width(), (int)ellipseSize.height(), (String)(ellipseSize.toString() + "_elem"));
        org.fortiss.tooling.base.model.layout.Point cartesianPoint = EllipseLayoutUtils.calculateEllipseBorderPoint((double)angle, (org.fortiss.tooling.base.model.layout.Dimension)ellipseSizeElement, (int)inset);
        return new Point(cartesianPoint.getX(), cartesianPoint.getY());
    }

    public static double getRadianFromDegree(double degree) {
        return Math.PI / 180 * degree;
    }

    public static Dimension clampEllipseShapeSize(Dimension oldSize, int direction) {
        return EllipseLayoutUIUtils.clampEllipseShapeSize(oldSize, direction, 108, 72, 1.6);
    }

    public static Dimension clampEllipseShapeSize(Dimension oldSize, int direction, int minimumWidth, int minimumHeight, double aspectRatio) {
        Dimension newSize = new Dimension(oldSize.width < minimumWidth ? minimumWidth : oldSize.width, oldSize.height < minimumHeight ? minimumHeight : oldSize.height);
        switch (direction) {
            case 20: {
                int aspectHeight = (int)((double)newSize.width / aspectRatio);
                int aspectWidth = (int)((double)newSize.height * aspectRatio);
                newSize.setSize(new Dimension(newSize.width > aspectWidth ? aspectWidth : newSize.width, newSize.height > aspectHeight ? aspectHeight : newSize.height));
                break;
            }
            case 4: {
                newSize.setSize(new Dimension((int)((double)newSize.height * aspectRatio), newSize.height));
                break;
            }
            case 16: {
                newSize.setSize(new Dimension(newSize.width, (int)((double)newSize.width / aspectRatio)));
            }
        }
        return newSize;
    }

    public static Rectangle getAbsoluteConnectorBounds(ILayoutedModelElement connector, ILayoutedModelElement parent) {
        Rectangle result = new Rectangle(0, 0, 24, 24);
        double angle = LayoutDataUtils.getConnectorAngleAsDouble((ILayoutedModelElement)connector);
        org.fortiss.tooling.base.model.layout.Dimension parentSize = LayoutDataUtils.getNodeSize((ILayoutedModelElement)parent);
        Dimension parentDim = new Dimension(parentSize.getWidth(), parentSize.getHeight());
        Point position = EllipseLayoutUIUtils.calculateEllipseBorderPoint(angle, parentDim, 12).translate(-12, -12);
        org.fortiss.tooling.base.model.layout.Point parentPos = LayoutDataUtils.getNodePosition((ILayoutedModelElement)parent);
        result.x = position.x + parentPos.getX();
        result.y = position.y + parentPos.getY();
        return result;
    }
}

